<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplaceRequestLineProduct StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReplaceRequestLineProduct
 * @subpackage Structs
 */
class ReplaceRequestLineProduct extends AbstractStructBase
{
    /**
     * The AdditionalDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdditionalDescription;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryDate;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Discounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestLineProductDiscountCollection
     */
    public $Discounts;
    /**
     * The EmployeeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmployeeId;
    /**
     * The ItemIdentifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestLineProductItemIdentifier
     */
    public $ItemIdentifier;
    /**
     * The MovementReasonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovementReasonId;
    /**
     * The Quantity
     * @var float
     */
    public $Quantity;
    /**
     * The References
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestLineProductReferences
     */
    public $References;
    /**
     * The SerialNumberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerialNumberId;
    /**
     * The TaxExcludedAmount
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\DocumentAmount
     */
    public $TaxExcludedAmount;
    /**
     * The TaxIncludedAmount
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\DocumentAmount
     */
    public $TaxIncludedAmount;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestLineProductTaxCollection
     */
    public $Taxes;
    /**
     * The WarehouseIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestLineProductWarehouseIdentifier
     */
    public $WarehouseIdentifier;
    /**
     * Constructor method for ReplaceRequestLineProduct
     * @uses ReplaceRequestLineProduct::setAdditionalDescription()
     * @uses ReplaceRequestLineProduct::setDeliveryDate()
     * @uses ReplaceRequestLineProduct::setDescription()
     * @uses ReplaceRequestLineProduct::setDiscounts()
     * @uses ReplaceRequestLineProduct::setEmployeeId()
     * @uses ReplaceRequestLineProduct::setItemIdentifier()
     * @uses ReplaceRequestLineProduct::setMovementReasonId()
     * @uses ReplaceRequestLineProduct::setQuantity()
     * @uses ReplaceRequestLineProduct::setReferences()
     * @uses ReplaceRequestLineProduct::setSerialNumberId()
     * @uses ReplaceRequestLineProduct::setTaxExcludedAmount()
     * @uses ReplaceRequestLineProduct::setTaxIncludedAmount()
     * @uses ReplaceRequestLineProduct::setTaxes()
     * @uses ReplaceRequestLineProduct::setWarehouseIdentifier()
     * @param string $additionalDescription
     * @param string $deliveryDate
     * @param string $description
     * @param \Cegid\StructType\ReplaceRequestLineProductDiscountCollection $discounts
     * @param string $employeeId
     * @param \Cegid\StructType\ReplaceRequestLineProductItemIdentifier $itemIdentifier
     * @param string $movementReasonId
     * @param float $quantity
     * @param \Cegid\StructType\ReplaceRequestLineProductReferences $references
     * @param string $serialNumberId
     * @param \Cegid\StructType\DocumentAmount $taxExcludedAmount
     * @param \Cegid\StructType\DocumentAmount $taxIncludedAmount
     * @param \Cegid\StructType\ReplaceRequestLineProductTaxCollection $taxes
     * @param \Cegid\StructType\ReplaceRequestLineProductWarehouseIdentifier $warehouseIdentifier
     */
    public function __construct($additionalDescription = null, $deliveryDate = null, $description = null, \Cegid\StructType\ReplaceRequestLineProductDiscountCollection $discounts = null, $employeeId = null, \Cegid\StructType\ReplaceRequestLineProductItemIdentifier $itemIdentifier = null, $movementReasonId = null, $quantity = null, \Cegid\StructType\ReplaceRequestLineProductReferences $references = null, $serialNumberId = null, \Cegid\StructType\DocumentAmount $taxExcludedAmount = null, \Cegid\StructType\DocumentAmount $taxIncludedAmount = null, \Cegid\StructType\ReplaceRequestLineProductTaxCollection $taxes = null, \Cegid\StructType\ReplaceRequestLineProductWarehouseIdentifier $warehouseIdentifier = null)
    {
        $this
            ->setAdditionalDescription($additionalDescription)
            ->setDeliveryDate($deliveryDate)
            ->setDescription($description)
            ->setDiscounts($discounts)
            ->setEmployeeId($employeeId)
            ->setItemIdentifier($itemIdentifier)
            ->setMovementReasonId($movementReasonId)
            ->setQuantity($quantity)
            ->setReferences($references)
            ->setSerialNumberId($serialNumberId)
            ->setTaxExcludedAmount($taxExcludedAmount)
            ->setTaxIncludedAmount($taxIncludedAmount)
            ->setTaxes($taxes)
            ->setWarehouseIdentifier($warehouseIdentifier);
    }
    /**
     * Get AdditionalDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalDescription()
    {
        return isset($this->AdditionalDescription) ? $this->AdditionalDescription : null;
    }
    /**
     * Set AdditionalDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalDescription
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setAdditionalDescription($additionalDescription = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDescription) && !is_string($additionalDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDescription, true), gettype($additionalDescription)), __LINE__);
        }
        if (is_null($additionalDescription) || (is_array($additionalDescription) && empty($additionalDescription))) {
            unset($this->AdditionalDescription);
        } else {
            $this->AdditionalDescription = $additionalDescription;
        }
        return $this;
    }
    /**
     * Get DeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return isset($this->DeliveryDate) ? $this->DeliveryDate : null;
    }
    /**
     * Set DeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryDate
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        if (is_null($deliveryDate) || (is_array($deliveryDate) && empty($deliveryDate))) {
            unset($this->DeliveryDate);
        } else {
            $this->DeliveryDate = $deliveryDate;
        }
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Discounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ReplaceRequestLineProductDiscountCollection|null
     */
    public function getDiscounts()
    {
        return isset($this->Discounts) ? $this->Discounts : null;
    }
    /**
     * Set Discounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\ReplaceRequestLineProductDiscountCollection $discounts
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setDiscounts(\Cegid\StructType\ReplaceRequestLineProductDiscountCollection $discounts = null)
    {
        if (is_null($discounts) || (is_array($discounts) && empty($discounts))) {
            unset($this->Discounts);
        } else {
            $this->Discounts = $discounts;
        }
        return $this;
    }
    /**
     * Get EmployeeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmployeeId()
    {
        return isset($this->EmployeeId) ? $this->EmployeeId : null;
    }
    /**
     * Set EmployeeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $employeeId
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setEmployeeId($employeeId = null)
    {
        // validation for constraint: string
        if (!is_null($employeeId) && !is_string($employeeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employeeId, true), gettype($employeeId)), __LINE__);
        }
        if (is_null($employeeId) || (is_array($employeeId) && empty($employeeId))) {
            unset($this->EmployeeId);
        } else {
            $this->EmployeeId = $employeeId;
        }
        return $this;
    }
    /**
     * Get ItemIdentifier value
     * @return \Cegid\StructType\ReplaceRequestLineProductItemIdentifier|null
     */
    public function getItemIdentifier()
    {
        return $this->ItemIdentifier;
    }
    /**
     * Set ItemIdentifier value
     * @param \Cegid\StructType\ReplaceRequestLineProductItemIdentifier $itemIdentifier
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setItemIdentifier(\Cegid\StructType\ReplaceRequestLineProductItemIdentifier $itemIdentifier = null)
    {
        $this->ItemIdentifier = $itemIdentifier;
        return $this;
    }
    /**
     * Get MovementReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovementReasonId()
    {
        return isset($this->MovementReasonId) ? $this->MovementReasonId : null;
    }
    /**
     * Set MovementReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $movementReasonId
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setMovementReasonId($movementReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($movementReasonId) && !is_string($movementReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($movementReasonId, true), gettype($movementReasonId)), __LINE__);
        }
        if (is_null($movementReasonId) || (is_array($movementReasonId) && empty($movementReasonId))) {
            unset($this->MovementReasonId);
        } else {
            $this->MovementReasonId = $movementReasonId;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get References value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ReplaceRequestLineProductReferences|null
     */
    public function getReferences()
    {
        return isset($this->References) ? $this->References : null;
    }
    /**
     * Set References value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\ReplaceRequestLineProductReferences $references
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setReferences(\Cegid\StructType\ReplaceRequestLineProductReferences $references = null)
    {
        if (is_null($references) || (is_array($references) && empty($references))) {
            unset($this->References);
        } else {
            $this->References = $references;
        }
        return $this;
    }
    /**
     * Get SerialNumberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerialNumberId()
    {
        return isset($this->SerialNumberId) ? $this->SerialNumberId : null;
    }
    /**
     * Set SerialNumberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serialNumberId
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setSerialNumberId($serialNumberId = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumberId) && !is_string($serialNumberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumberId, true), gettype($serialNumberId)), __LINE__);
        }
        if (is_null($serialNumberId) || (is_array($serialNumberId) && empty($serialNumberId))) {
            unset($this->SerialNumberId);
        } else {
            $this->SerialNumberId = $serialNumberId;
        }
        return $this;
    }
    /**
     * Get TaxExcludedAmount value
     * @return \Cegid\StructType\DocumentAmount|null
     */
    public function getTaxExcludedAmount()
    {
        return $this->TaxExcludedAmount;
    }
    /**
     * Set TaxExcludedAmount value
     * @param \Cegid\StructType\DocumentAmount $taxExcludedAmount
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setTaxExcludedAmount(\Cegid\StructType\DocumentAmount $taxExcludedAmount = null)
    {
        $this->TaxExcludedAmount = $taxExcludedAmount;
        return $this;
    }
    /**
     * Get TaxIncludedAmount value
     * @return \Cegid\StructType\DocumentAmount|null
     */
    public function getTaxIncludedAmount()
    {
        return $this->TaxIncludedAmount;
    }
    /**
     * Set TaxIncludedAmount value
     * @param \Cegid\StructType\DocumentAmount $taxIncludedAmount
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setTaxIncludedAmount(\Cegid\StructType\DocumentAmount $taxIncludedAmount = null)
    {
        $this->TaxIncludedAmount = $taxIncludedAmount;
        return $this;
    }
    /**
     * Get Taxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ReplaceRequestLineProductTaxCollection|null
     */
    public function getTaxes()
    {
        return isset($this->Taxes) ? $this->Taxes : null;
    }
    /**
     * Set Taxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\ReplaceRequestLineProductTaxCollection $taxes
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setTaxes(\Cegid\StructType\ReplaceRequestLineProductTaxCollection $taxes = null)
    {
        if (is_null($taxes) || (is_array($taxes) && empty($taxes))) {
            unset($this->Taxes);
        } else {
            $this->Taxes = $taxes;
        }
        return $this;
    }
    /**
     * Get WarehouseIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ReplaceRequestLineProductWarehouseIdentifier|null
     */
    public function getWarehouseIdentifier()
    {
        return isset($this->WarehouseIdentifier) ? $this->WarehouseIdentifier : null;
    }
    /**
     * Set WarehouseIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\ReplaceRequestLineProductWarehouseIdentifier $warehouseIdentifier
     * @return \Cegid\StructType\ReplaceRequestLineProduct
     */
    public function setWarehouseIdentifier(\Cegid\StructType\ReplaceRequestLineProductWarehouseIdentifier $warehouseIdentifier = null)
    {
        if (is_null($warehouseIdentifier) || (is_array($warehouseIdentifier) && empty($warehouseIdentifier))) {
            unset($this->WarehouseIdentifier);
        } else {
            $this->WarehouseIdentifier = $warehouseIdentifier;
        }
        return $this;
    }
}
