<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplaceRequestHeaderCustomerAddressCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReplaceRequestHeaderCustomerAddressCollection
 * @subpackage Structs
 */
class ReplaceRequestHeaderCustomerAddressCollection extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestHeaderCustomerAddress[]
     */
    public $Address;
    /**
     * Constructor method for ReplaceRequestHeaderCustomerAddressCollection
     * @uses ReplaceRequestHeaderCustomerAddressCollection::setAddress()
     * @param \Cegid\StructType\ReplaceRequestHeaderCustomerAddress[] $address
     */
    public function __construct(array $address = array())
    {
        $this
            ->setAddress($address);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ReplaceRequestHeaderCustomerAddress[]|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $replaceRequestHeaderCustomerAddressCollectionAddressItem) {
            // validation for constraint: itemType
            if (!$replaceRequestHeaderCustomerAddressCollectionAddressItem instanceof \Cegid\StructType\ReplaceRequestHeaderCustomerAddress) {
                $invalidValues[] = is_object($replaceRequestHeaderCustomerAddressCollectionAddressItem) ? get_class($replaceRequestHeaderCustomerAddressCollectionAddressItem) : sprintf('%s(%s)', gettype($replaceRequestHeaderCustomerAddressCollectionAddressItem), var_export($replaceRequestHeaderCustomerAddressCollectionAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \Cegid\StructType\ReplaceRequestHeaderCustomerAddress, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\ReplaceRequestHeaderCustomerAddress[] $address
     * @return \Cegid\StructType\ReplaceRequestHeaderCustomerAddressCollection
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\ReplaceRequestHeaderCustomerAddress $item
     * @return \Cegid\StructType\ReplaceRequestHeaderCustomerAddressCollection
     */
    public function addToAddress(\Cegid\StructType\ReplaceRequestHeaderCustomerAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\ReplaceRequestHeaderCustomerAddress) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \Cegid\StructType\ReplaceRequestHeaderCustomerAddress, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
}
