<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplaceRequestHeader StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReplaceRequestHeader
 * @subpackage Structs
 */
class ReplaceRequestHeader extends AbstractStructBase
{
    /**
     * The CurrencyId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CurrencyId;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestHeaderCustomer
     */
    public $Customer;
    /**
     * The DeliveryDate
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DocumentDate
     * @var string
     */
    public $DocumentDate;
    /**
     * The Employees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestHeaderEmployeeCollection
     */
    public $Employees;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestHeaderKey
     */
    public $Key;
    /**
     * The OmniChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestHeaderOmniChannel
     */
    public $OmniChannel;
    /**
     * The References
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestHeaderReferences
     */
    public $References;
    /**
     * The StoreIdentifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestHeaderStoreIdentifier
     */
    public $StoreIdentifier;
    /**
     * The TaxExcluded
     * @var bool
     */
    public $TaxExcluded;
    /**
     * The UserDefined
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestHeaderUserDefined
     */
    public $UserDefined;
    /**
     * The UserFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfUserFieldForPost
     */
    public $UserFields;
    /**
     * The WarehouseIdentifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestHeaderWarehouseIdentifier
     */
    public $WarehouseIdentifier;
    /**
     * Constructor method for ReplaceRequestHeader
     * @uses ReplaceRequestHeader::setCurrencyId()
     * @uses ReplaceRequestHeader::setCustomer()
     * @uses ReplaceRequestHeader::setDeliveryDate()
     * @uses ReplaceRequestHeader::setDocumentDate()
     * @uses ReplaceRequestHeader::setEmployees()
     * @uses ReplaceRequestHeader::setKey()
     * @uses ReplaceRequestHeader::setOmniChannel()
     * @uses ReplaceRequestHeader::setReferences()
     * @uses ReplaceRequestHeader::setStoreIdentifier()
     * @uses ReplaceRequestHeader::setTaxExcluded()
     * @uses ReplaceRequestHeader::setUserDefined()
     * @uses ReplaceRequestHeader::setUserFields()
     * @uses ReplaceRequestHeader::setWarehouseIdentifier()
     * @param string $currencyId
     * @param \Cegid\StructType\ReplaceRequestHeaderCustomer $customer
     * @param string $deliveryDate
     * @param string $documentDate
     * @param \Cegid\StructType\ReplaceRequestHeaderEmployeeCollection $employees
     * @param \Cegid\StructType\ReplaceRequestHeaderKey $key
     * @param \Cegid\StructType\ReplaceRequestHeaderOmniChannel $omniChannel
     * @param \Cegid\StructType\ReplaceRequestHeaderReferences $references
     * @param \Cegid\StructType\ReplaceRequestHeaderStoreIdentifier $storeIdentifier
     * @param bool $taxExcluded
     * @param \Cegid\StructType\ReplaceRequestHeaderUserDefined $userDefined
     * @param \Cegid\ArrayType\ArrayOfUserFieldForPost $userFields
     * @param \Cegid\StructType\ReplaceRequestHeaderWarehouseIdentifier $warehouseIdentifier
     */
    public function __construct($currencyId = null, \Cegid\StructType\ReplaceRequestHeaderCustomer $customer = null, $deliveryDate = null, $documentDate = null, \Cegid\StructType\ReplaceRequestHeaderEmployeeCollection $employees = null, \Cegid\StructType\ReplaceRequestHeaderKey $key = null, \Cegid\StructType\ReplaceRequestHeaderOmniChannel $omniChannel = null, \Cegid\StructType\ReplaceRequestHeaderReferences $references = null, \Cegid\StructType\ReplaceRequestHeaderStoreIdentifier $storeIdentifier = null, $taxExcluded = null, \Cegid\StructType\ReplaceRequestHeaderUserDefined $userDefined = null, \Cegid\ArrayType\ArrayOfUserFieldForPost $userFields = null, \Cegid\StructType\ReplaceRequestHeaderWarehouseIdentifier $warehouseIdentifier = null)
    {
        $this
            ->setCurrencyId($currencyId)
            ->setCustomer($customer)
            ->setDeliveryDate($deliveryDate)
            ->setDocumentDate($documentDate)
            ->setEmployees($employees)
            ->setKey($key)
            ->setOmniChannel($omniChannel)
            ->setReferences($references)
            ->setStoreIdentifier($storeIdentifier)
            ->setTaxExcluded($taxExcluded)
            ->setUserDefined($userDefined)
            ->setUserFields($userFields)
            ->setWarehouseIdentifier($warehouseIdentifier);
    }
    /**
     * Get CurrencyId value
     * @return string|null
     */
    public function getCurrencyId()
    {
        return $this->CurrencyId;
    }
    /**
     * Set CurrencyId value
     * @param string $currencyId
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: string
        if (!is_null($currencyId) && !is_string($currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyId, true), gettype($currencyId)), __LINE__);
        }
        $this->CurrencyId = $currencyId;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Cegid\StructType\ReplaceRequestHeaderCustomer|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Cegid\StructType\ReplaceRequestHeaderCustomer $customer
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setCustomer(\Cegid\StructType\ReplaceRequestHeaderCustomer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DocumentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }
    /**
     * Set DocumentDate value
     * @param string $documentDate
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        $this->DocumentDate = $documentDate;
        return $this;
    }
    /**
     * Get Employees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ReplaceRequestHeaderEmployeeCollection|null
     */
    public function getEmployees()
    {
        return isset($this->Employees) ? $this->Employees : null;
    }
    /**
     * Set Employees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\ReplaceRequestHeaderEmployeeCollection $employees
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setEmployees(\Cegid\StructType\ReplaceRequestHeaderEmployeeCollection $employees = null)
    {
        if (is_null($employees) || (is_array($employees) && empty($employees))) {
            unset($this->Employees);
        } else {
            $this->Employees = $employees;
        }
        return $this;
    }
    /**
     * Get Key value
     * @return \Cegid\StructType\ReplaceRequestHeaderKey|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param \Cegid\StructType\ReplaceRequestHeaderKey $key
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setKey(\Cegid\StructType\ReplaceRequestHeaderKey $key = null)
    {
        $this->Key = $key;
        return $this;
    }
    /**
     * Get OmniChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ReplaceRequestHeaderOmniChannel|null
     */
    public function getOmniChannel()
    {
        return isset($this->OmniChannel) ? $this->OmniChannel : null;
    }
    /**
     * Set OmniChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\ReplaceRequestHeaderOmniChannel $omniChannel
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setOmniChannel(\Cegid\StructType\ReplaceRequestHeaderOmniChannel $omniChannel = null)
    {
        if (is_null($omniChannel) || (is_array($omniChannel) && empty($omniChannel))) {
            unset($this->OmniChannel);
        } else {
            $this->OmniChannel = $omniChannel;
        }
        return $this;
    }
    /**
     * Get References value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ReplaceRequestHeaderReferences|null
     */
    public function getReferences()
    {
        return isset($this->References) ? $this->References : null;
    }
    /**
     * Set References value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\ReplaceRequestHeaderReferences $references
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setReferences(\Cegid\StructType\ReplaceRequestHeaderReferences $references = null)
    {
        if (is_null($references) || (is_array($references) && empty($references))) {
            unset($this->References);
        } else {
            $this->References = $references;
        }
        return $this;
    }
    /**
     * Get StoreIdentifier value
     * @return \Cegid\StructType\ReplaceRequestHeaderStoreIdentifier|null
     */
    public function getStoreIdentifier()
    {
        return $this->StoreIdentifier;
    }
    /**
     * Set StoreIdentifier value
     * @param \Cegid\StructType\ReplaceRequestHeaderStoreIdentifier $storeIdentifier
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setStoreIdentifier(\Cegid\StructType\ReplaceRequestHeaderStoreIdentifier $storeIdentifier = null)
    {
        $this->StoreIdentifier = $storeIdentifier;
        return $this;
    }
    /**
     * Get TaxExcluded value
     * @return bool|null
     */
    public function getTaxExcluded()
    {
        return $this->TaxExcluded;
    }
    /**
     * Set TaxExcluded value
     * @param bool $taxExcluded
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setTaxExcluded($taxExcluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxExcluded) && !is_bool($taxExcluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxExcluded, true), gettype($taxExcluded)), __LINE__);
        }
        $this->TaxExcluded = $taxExcluded;
        return $this;
    }
    /**
     * Get UserDefined value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ReplaceRequestHeaderUserDefined|null
     */
    public function getUserDefined()
    {
        return isset($this->UserDefined) ? $this->UserDefined : null;
    }
    /**
     * Set UserDefined value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\ReplaceRequestHeaderUserDefined $userDefined
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setUserDefined(\Cegid\StructType\ReplaceRequestHeaderUserDefined $userDefined = null)
    {
        if (is_null($userDefined) || (is_array($userDefined) && empty($userDefined))) {
            unset($this->UserDefined);
        } else {
            $this->UserDefined = $userDefined;
        }
        return $this;
    }
    /**
     * Get UserFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\ArrayType\ArrayOfUserFieldForPost|null
     */
    public function getUserFields()
    {
        return isset($this->UserFields) ? $this->UserFields : null;
    }
    /**
     * Set UserFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\ArrayType\ArrayOfUserFieldForPost $userFields
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setUserFields(\Cegid\ArrayType\ArrayOfUserFieldForPost $userFields = null)
    {
        if (is_null($userFields) || (is_array($userFields) && empty($userFields))) {
            unset($this->UserFields);
        } else {
            $this->UserFields = $userFields;
        }
        return $this;
    }
    /**
     * Get WarehouseIdentifier value
     * @return \Cegid\StructType\ReplaceRequestHeaderWarehouseIdentifier|null
     */
    public function getWarehouseIdentifier()
    {
        return $this->WarehouseIdentifier;
    }
    /**
     * Set WarehouseIdentifier value
     * @param \Cegid\StructType\ReplaceRequestHeaderWarehouseIdentifier $warehouseIdentifier
     * @return \Cegid\StructType\ReplaceRequestHeader
     */
    public function setWarehouseIdentifier(\Cegid\StructType\ReplaceRequestHeaderWarehouseIdentifier $warehouseIdentifier = null)
    {
        $this->WarehouseIdentifier = $warehouseIdentifier;
        return $this;
    }
}
