<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pagination StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Pagination
 * @subpackage Structs
 */
class Pagination extends AbstractStructBase
{
    /**
     * The Count
     * @var int
     */
    public $Count;
    /**
     * The From
     * @var int
     */
    public $From;
    /**
     * The Max
     * @var int
     */
    public $Max;
    /**
     * The Resource
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Resource;
    /**
     * The To
     * @var int
     */
    public $To;
    /**
     * Constructor method for Pagination
     * @uses Pagination::setCount()
     * @uses Pagination::setFrom()
     * @uses Pagination::setMax()
     * @uses Pagination::setResource()
     * @uses Pagination::setTo()
     * @param int $count
     * @param int $from
     * @param int $max
     * @param string $resource
     * @param int $to
     */
    public function __construct($count = null, $from = null, $max = null, $resource = null, $to = null)
    {
        $this
            ->setCount($count)
            ->setFrom($from)
            ->setMax($max)
            ->setResource($resource)
            ->setTo($to);
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \Cegid\StructType\Pagination
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get From value
     * @return int|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param int $from
     * @return \Cegid\StructType\Pagination
     */
    public function setFrom($from = null)
    {
        // validation for constraint: int
        if (!is_null($from) && !(is_int($from) || ctype_digit($from))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get Max value
     * @return int|null
     */
    public function getMax()
    {
        return $this->Max;
    }
    /**
     * Set Max value
     * @param int $max
     * @return \Cegid\StructType\Pagination
     */
    public function setMax($max = null)
    {
        // validation for constraint: int
        if (!is_null($max) && !(is_int($max) || ctype_digit($max))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($max, true), gettype($max)), __LINE__);
        }
        $this->Max = $max;
        return $this;
    }
    /**
     * Get Resource value
     * @return string|null
     */
    public function getResource()
    {
        return $this->Resource;
    }
    /**
     * Set Resource value
     * @param string $resource
     * @return \Cegid\StructType\Pagination
     */
    public function setResource($resource = null)
    {
        // validation for constraint: string
        if (!is_null($resource) && !is_string($resource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource, true), gettype($resource)), __LINE__);
        }
        $this->Resource = $resource;
        return $this;
    }
    /**
     * Get To value
     * @return int|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param int $to
     * @return \Cegid\StructType\Pagination
     */
    public function setTo($to = null)
    {
        // validation for constraint: int
        if (!is_null($to) && !(is_int($to) || ctype_digit($to))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
}
