<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetListDetailRequestOmniChannel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetListDetailRequestOmniChannel
 * @subpackage Structs
 */
class GetListDetailRequestOmniChannel extends AbstractStructBase
{
    /**
     * The DeliveryStoreId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryStoreId;
    /**
     * The DeliveryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryType;
    /**
     * The DeliveryWarehouseId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryWarehouseId;
    /**
     * The FollowUpStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderFollowUpStatusSELWU3Qp
     */
    public $FollowUpStatus;
    /**
     * Constructor method for GetListDetailRequestOmniChannel
     * @uses GetListDetailRequestOmniChannel::setDeliveryStoreId()
     * @uses GetListDetailRequestOmniChannel::setDeliveryType()
     * @uses GetListDetailRequestOmniChannel::setDeliveryWarehouseId()
     * @uses GetListDetailRequestOmniChannel::setFollowUpStatus()
     * @param string $deliveryStoreId
     * @param string $deliveryType
     * @param string $deliveryWarehouseId
     * @param \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderFollowUpStatusSELWU3Qp $followUpStatus
     */
    public function __construct($deliveryStoreId = null, $deliveryType = null, $deliveryWarehouseId = null, \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderFollowUpStatusSELWU3Qp $followUpStatus = null)
    {
        $this
            ->setDeliveryStoreId($deliveryStoreId)
            ->setDeliveryType($deliveryType)
            ->setDeliveryWarehouseId($deliveryWarehouseId)
            ->setFollowUpStatus($followUpStatus);
    }
    /**
     * Get DeliveryStoreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryStoreId()
    {
        return isset($this->DeliveryStoreId) ? $this->DeliveryStoreId : null;
    }
    /**
     * Set DeliveryStoreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryStoreId
     * @return \Cegid\StructType\GetListDetailRequestOmniChannel
     */
    public function setDeliveryStoreId($deliveryStoreId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStoreId) && !is_string($deliveryStoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryStoreId, true), gettype($deliveryStoreId)), __LINE__);
        }
        if (is_null($deliveryStoreId) || (is_array($deliveryStoreId) && empty($deliveryStoreId))) {
            unset($this->DeliveryStoreId);
        } else {
            $this->DeliveryStoreId = $deliveryStoreId;
        }
        return $this;
    }
    /**
     * Get DeliveryType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryType()
    {
        return isset($this->DeliveryType) ? $this->DeliveryType : null;
    }
    /**
     * Set DeliveryType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Cegid\EnumType\CustomerOrderDeliveryType::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderDeliveryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryType
     * @return \Cegid\StructType\GetListDetailRequestOmniChannel
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderDeliveryType::valueIsValid($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderDeliveryType', is_array($deliveryType) ? implode(', ', $deliveryType) : var_export($deliveryType, true), implode(', ', \Cegid\EnumType\CustomerOrderDeliveryType::getValidValues())), __LINE__);
        }
        if (is_null($deliveryType) || (is_array($deliveryType) && empty($deliveryType))) {
            unset($this->DeliveryType);
        } else {
            $this->DeliveryType = $deliveryType;
        }
        return $this;
    }
    /**
     * Get DeliveryWarehouseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryWarehouseId()
    {
        return isset($this->DeliveryWarehouseId) ? $this->DeliveryWarehouseId : null;
    }
    /**
     * Set DeliveryWarehouseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryWarehouseId
     * @return \Cegid\StructType\GetListDetailRequestOmniChannel
     */
    public function setDeliveryWarehouseId($deliveryWarehouseId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryWarehouseId) && !is_string($deliveryWarehouseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryWarehouseId, true), gettype($deliveryWarehouseId)), __LINE__);
        }
        if (is_null($deliveryWarehouseId) || (is_array($deliveryWarehouseId) && empty($deliveryWarehouseId))) {
            unset($this->DeliveryWarehouseId);
        } else {
            $this->DeliveryWarehouseId = $deliveryWarehouseId;
        }
        return $this;
    }
    /**
     * Get FollowUpStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderFollowUpStatusSELWU3Qp|null
     */
    public function getFollowUpStatus()
    {
        return isset($this->FollowUpStatus) ? $this->FollowUpStatus : null;
    }
    /**
     * Set FollowUpStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderFollowUpStatusSELWU3Qp $followUpStatus
     * @return \Cegid\StructType\GetListDetailRequestOmniChannel
     */
    public function setFollowUpStatus(\Cegid\ArrayType\ArrayOfNullableOfCustomerOrderFollowUpStatusSELWU3Qp $followUpStatus = null)
    {
        if (is_null($followUpStatus) || (is_array($followUpStatus) && empty($followUpStatus))) {
            unset($this->FollowUpStatus);
        } else {
            $this->FollowUpStatus = $followUpStatus;
        }
        return $this;
    }
}
