<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderLineTaxCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderLineTaxCollection
 * @subpackage Structs
 */
class CustomerOrderLineTaxCollection extends AbstractStructBase
{
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderLineTax[]
     */
    public $Tax;
    /**
     * Constructor method for CustomerOrderLineTaxCollection
     * @uses CustomerOrderLineTaxCollection::setTax()
     * @param \Cegid\StructType\CustomerOrderLineTax[] $tax
     */
    public function __construct(array $tax = array())
    {
        $this
            ->setTax($tax);
    }
    /**
     * Get Tax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CustomerOrderLineTax[]|null
     */
    public function getTax()
    {
        return isset($this->Tax) ? $this->Tax : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerOrderLineTaxCollectionTaxItem) {
            // validation for constraint: itemType
            if (!$customerOrderLineTaxCollectionTaxItem instanceof \Cegid\StructType\CustomerOrderLineTax) {
                $invalidValues[] = is_object($customerOrderLineTaxCollectionTaxItem) ? get_class($customerOrderLineTaxCollectionTaxItem) : sprintf('%s(%s)', gettype($customerOrderLineTaxCollectionTaxItem), var_export($customerOrderLineTaxCollectionTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \Cegid\StructType\CustomerOrderLineTax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CustomerOrderLineTax[] $tax
     * @return \Cegid\StructType\CustomerOrderLineTaxCollection
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        if (is_null($tax) || (is_array($tax) && empty($tax))) {
            unset($this->Tax);
        } else {
            $this->Tax = $tax;
        }
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CustomerOrderLineTax $item
     * @return \Cegid\StructType\CustomerOrderLineTaxCollection
     */
    public function addToTax(\Cegid\StructType\CustomerOrderLineTax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\CustomerOrderLineTax) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \Cegid\StructType\CustomerOrderLineTax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
}
