<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderLineQuantities StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderLineQuantities
 * @subpackage Structs
 */
class CustomerOrderLineQuantities extends AbstractStructBase
{
    /**
     * The Quantity
     * @var float
     */
    public $Quantity;
    /**
     * The Remaining
     * @var float
     */
    public $Remaining;
    /**
     * Constructor method for CustomerOrderLineQuantities
     * @uses CustomerOrderLineQuantities::setQuantity()
     * @uses CustomerOrderLineQuantities::setRemaining()
     * @param float $quantity
     * @param float $remaining
     */
    public function __construct($quantity = null, $remaining = null)
    {
        $this
            ->setQuantity($quantity)
            ->setRemaining($remaining);
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \Cegid\StructType\CustomerOrderLineQuantities
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Remaining value
     * @return float|null
     */
    public function getRemaining()
    {
        return $this->Remaining;
    }
    /**
     * Set Remaining value
     * @param float $remaining
     * @return \Cegid\StructType\CustomerOrderLineQuantities
     */
    public function setRemaining($remaining = null)
    {
        // validation for constraint: float
        if (!is_null($remaining) && !(is_float($remaining) || is_numeric($remaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remaining, true), gettype($remaining)), __LINE__);
        }
        $this->Remaining = $remaining;
        return $this;
    }
}
