<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderLineLinkedDocumentCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderLineLinkedDocumentCollection
 * @subpackage Structs
 */
class CustomerOrderLineLinkedDocumentCollection extends AbstractStructBase
{
    /**
     * The LinkedDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderLineLinkedDocument[]
     */
    public $LinkedDocument;
    /**
     * Constructor method for CustomerOrderLineLinkedDocumentCollection
     * @uses CustomerOrderLineLinkedDocumentCollection::setLinkedDocument()
     * @param \Cegid\StructType\CustomerOrderLineLinkedDocument[] $linkedDocument
     */
    public function __construct(array $linkedDocument = array())
    {
        $this
            ->setLinkedDocument($linkedDocument);
    }
    /**
     * Get LinkedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocument[]|null
     */
    public function getLinkedDocument()
    {
        return isset($this->LinkedDocument) ? $this->LinkedDocument : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLinkedDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLinkedDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLinkedDocumentForArrayConstraintsFromSetLinkedDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerOrderLineLinkedDocumentCollectionLinkedDocumentItem) {
            // validation for constraint: itemType
            if (!$customerOrderLineLinkedDocumentCollectionLinkedDocumentItem instanceof \Cegid\StructType\CustomerOrderLineLinkedDocument) {
                $invalidValues[] = is_object($customerOrderLineLinkedDocumentCollectionLinkedDocumentItem) ? get_class($customerOrderLineLinkedDocumentCollectionLinkedDocumentItem) : sprintf('%s(%s)', gettype($customerOrderLineLinkedDocumentCollectionLinkedDocumentItem), var_export($customerOrderLineLinkedDocumentCollectionLinkedDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LinkedDocument property can only contain items of type \Cegid\StructType\CustomerOrderLineLinkedDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LinkedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CustomerOrderLineLinkedDocument[] $linkedDocument
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocumentCollection
     */
    public function setLinkedDocument(array $linkedDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($linkedDocumentArrayErrorMessage = self::validateLinkedDocumentForArrayConstraintsFromSetLinkedDocument($linkedDocument))) {
            throw new \InvalidArgumentException($linkedDocumentArrayErrorMessage, __LINE__);
        }
        if (is_null($linkedDocument) || (is_array($linkedDocument) && empty($linkedDocument))) {
            unset($this->LinkedDocument);
        } else {
            $this->LinkedDocument = $linkedDocument;
        }
        return $this;
    }
    /**
     * Add item to LinkedDocument value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CustomerOrderLineLinkedDocument $item
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocumentCollection
     */
    public function addToLinkedDocument(\Cegid\StructType\CustomerOrderLineLinkedDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\CustomerOrderLineLinkedDocument) {
            throw new \InvalidArgumentException(sprintf('The LinkedDocument property can only contain items of type \Cegid\StructType\CustomerOrderLineLinkedDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LinkedDocument[] = $item;
        return $this;
    }
}
