<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderLineLinkedDocument StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderLineLinkedDocument
 * @subpackage Structs
 */
class CustomerOrderLineLinkedDocument extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderLineLinkedDocumentKey
     */
    public $Key;
    /**
     * The TypeOfLink
     * @var string
     */
    public $TypeOfLink;
    /**
     * Constructor method for CustomerOrderLineLinkedDocument
     * @uses CustomerOrderLineLinkedDocument::setKey()
     * @uses CustomerOrderLineLinkedDocument::setTypeOfLink()
     * @param \Cegid\StructType\CustomerOrderLineLinkedDocumentKey $key
     * @param string $typeOfLink
     */
    public function __construct(\Cegid\StructType\CustomerOrderLineLinkedDocumentKey $key = null, $typeOfLink = null)
    {
        $this
            ->setKey($key)
            ->setTypeOfLink($typeOfLink);
    }
    /**
     * Get Key value
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocumentKey|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param \Cegid\StructType\CustomerOrderLineLinkedDocumentKey $key
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocument
     */
    public function setKey(\Cegid\StructType\CustomerOrderLineLinkedDocumentKey $key = null)
    {
        $this->Key = $key;
        return $this;
    }
    /**
     * Get TypeOfLink value
     * @return string|null
     */
    public function getTypeOfLink()
    {
        return $this->TypeOfLink;
    }
    /**
     * Set TypeOfLink value
     * @uses \Cegid\EnumType\TypeOfLink::valueIsValid()
     * @uses \Cegid\EnumType\TypeOfLink::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfLink
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocument
     */
    public function setTypeOfLink($typeOfLink = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\TypeOfLink::valueIsValid($typeOfLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\TypeOfLink', is_array($typeOfLink) ? implode(', ', $typeOfLink) : var_export($typeOfLink, true), implode(', ', \Cegid\EnumType\TypeOfLink::getValidValues())), __LINE__);
        }
        $this->TypeOfLink = $typeOfLink;
        return $this;
    }
}
