<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderLine StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderLine
 * @subpackage Structs
 */
class CustomerOrderLine extends AbstractStructBase
{
    /**
     * The Active
     * @var bool
     */
    public $Active;
    /**
     * The AdditionalDescription
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AdditionalDescription;
    /**
     * The DeliveryDate
     * @var string
     */
    public $DeliveryDate;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Discounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderLineDiscountCollection
     */
    public $Discounts;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The Id
     * @var int
     */
    public $Id;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderLineItem
     */
    public $Item;
    /**
     * The LinkedDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderLineLinkedDocumentCollection
     */
    public $LinkedDocuments;
    /**
     * The MovementReasonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovementReasonId;
    /**
     * The NetAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NetAmount;
    /**
     * The PackageReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackageReference;
    /**
     * The Quantities
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderLineQuantities
     */
    public $Quantities;
    /**
     * The Rank
     * @var int
     */
    public $Rank;
    /**
     * The SalespersonId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SalespersonId;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderLineTaxCollection
     */
    public $Taxes;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $UnitPrice;
    /**
     * The WarehouseId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $WarehouseId;
    /**
     * Constructor method for CustomerOrderLine
     * @uses CustomerOrderLine::setActive()
     * @uses CustomerOrderLine::setAdditionalDescription()
     * @uses CustomerOrderLine::setDeliveryDate()
     * @uses CustomerOrderLine::setDescription()
     * @uses CustomerOrderLine::setDiscounts()
     * @uses CustomerOrderLine::setExpiryDate()
     * @uses CustomerOrderLine::setExternalReference()
     * @uses CustomerOrderLine::setId()
     * @uses CustomerOrderLine::setItem()
     * @uses CustomerOrderLine::setLinkedDocuments()
     * @uses CustomerOrderLine::setMovementReasonId()
     * @uses CustomerOrderLine::setNetAmount()
     * @uses CustomerOrderLine::setPackageReference()
     * @uses CustomerOrderLine::setQuantities()
     * @uses CustomerOrderLine::setRank()
     * @uses CustomerOrderLine::setSalespersonId()
     * @uses CustomerOrderLine::setTaxes()
     * @uses CustomerOrderLine::setType()
     * @uses CustomerOrderLine::setUnitPrice()
     * @uses CustomerOrderLine::setWarehouseId()
     * @param bool $active
     * @param string $additionalDescription
     * @param string $deliveryDate
     * @param string $description
     * @param \Cegid\StructType\CustomerOrderLineDiscountCollection $discounts
     * @param string $expiryDate
     * @param string $externalReference
     * @param int $id
     * @param \Cegid\StructType\CustomerOrderLineItem $item
     * @param \Cegid\StructType\CustomerOrderLineLinkedDocumentCollection $linkedDocuments
     * @param string $movementReasonId
     * @param float $netAmount
     * @param string $packageReference
     * @param \Cegid\StructType\CustomerOrderLineQuantities $quantities
     * @param int $rank
     * @param string $salespersonId
     * @param \Cegid\StructType\CustomerOrderLineTaxCollection $taxes
     * @param string $type
     * @param float $unitPrice
     * @param string $warehouseId
     */
    public function __construct($active = null, $additionalDescription = null, $deliveryDate = null, $description = null, \Cegid\StructType\CustomerOrderLineDiscountCollection $discounts = null, $expiryDate = null, $externalReference = null, $id = null, \Cegid\StructType\CustomerOrderLineItem $item = null, \Cegid\StructType\CustomerOrderLineLinkedDocumentCollection $linkedDocuments = null, $movementReasonId = null, $netAmount = null, $packageReference = null, \Cegid\StructType\CustomerOrderLineQuantities $quantities = null, $rank = null, $salespersonId = null, \Cegid\StructType\CustomerOrderLineTaxCollection $taxes = null, $type = null, $unitPrice = null, $warehouseId = null)
    {
        $this
            ->setActive($active)
            ->setAdditionalDescription($additionalDescription)
            ->setDeliveryDate($deliveryDate)
            ->setDescription($description)
            ->setDiscounts($discounts)
            ->setExpiryDate($expiryDate)
            ->setExternalReference($externalReference)
            ->setId($id)
            ->setItem($item)
            ->setLinkedDocuments($linkedDocuments)
            ->setMovementReasonId($movementReasonId)
            ->setNetAmount($netAmount)
            ->setPackageReference($packageReference)
            ->setQuantities($quantities)
            ->setRank($rank)
            ->setSalespersonId($salespersonId)
            ->setTaxes($taxes)
            ->setType($type)
            ->setUnitPrice($unitPrice)
            ->setWarehouseId($warehouseId);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get AdditionalDescription value
     * @return string|null
     */
    public function getAdditionalDescription()
    {
        return $this->AdditionalDescription;
    }
    /**
     * Set AdditionalDescription value
     * @param string $additionalDescription
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setAdditionalDescription($additionalDescription = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDescription) && !is_string($additionalDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDescription, true), gettype($additionalDescription)), __LINE__);
        }
        $this->AdditionalDescription = $additionalDescription;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Discounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CustomerOrderLineDiscountCollection|null
     */
    public function getDiscounts()
    {
        return isset($this->Discounts) ? $this->Discounts : null;
    }
    /**
     * Set Discounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CustomerOrderLineDiscountCollection $discounts
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setDiscounts(\Cegid\StructType\CustomerOrderLineDiscountCollection $discounts = null)
    {
        if (is_null($discounts) || (is_array($discounts) && empty($discounts))) {
            unset($this->Discounts);
        } else {
            $this->Discounts = $discounts;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get ExternalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->ExternalReference;
    }
    /**
     * Set ExternalReference value
     * @param string $externalReference
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        $this->ExternalReference = $externalReference;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Item value
     * @return \Cegid\StructType\CustomerOrderLineItem|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \Cegid\StructType\CustomerOrderLineItem $item
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setItem(\Cegid\StructType\CustomerOrderLineItem $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get LinkedDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocumentCollection|null
     */
    public function getLinkedDocuments()
    {
        return isset($this->LinkedDocuments) ? $this->LinkedDocuments : null;
    }
    /**
     * Set LinkedDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CustomerOrderLineLinkedDocumentCollection $linkedDocuments
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setLinkedDocuments(\Cegid\StructType\CustomerOrderLineLinkedDocumentCollection $linkedDocuments = null)
    {
        if (is_null($linkedDocuments) || (is_array($linkedDocuments) && empty($linkedDocuments))) {
            unset($this->LinkedDocuments);
        } else {
            $this->LinkedDocuments = $linkedDocuments;
        }
        return $this;
    }
    /**
     * Get MovementReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovementReasonId()
    {
        return isset($this->MovementReasonId) ? $this->MovementReasonId : null;
    }
    /**
     * Set MovementReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $movementReasonId
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setMovementReasonId($movementReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($movementReasonId) && !is_string($movementReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($movementReasonId, true), gettype($movementReasonId)), __LINE__);
        }
        if (is_null($movementReasonId) || (is_array($movementReasonId) && empty($movementReasonId))) {
            unset($this->MovementReasonId);
        } else {
            $this->MovementReasonId = $movementReasonId;
        }
        return $this;
    }
    /**
     * Get NetAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNetAmount()
    {
        return isset($this->NetAmount) ? $this->NetAmount : null;
    }
    /**
     * Set NetAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $netAmount
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setNetAmount($netAmount = null)
    {
        // validation for constraint: float
        if (!is_null($netAmount) && !(is_float($netAmount) || is_numeric($netAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netAmount, true), gettype($netAmount)), __LINE__);
        }
        if (is_null($netAmount) || (is_array($netAmount) && empty($netAmount))) {
            unset($this->NetAmount);
        } else {
            $this->NetAmount = $netAmount;
        }
        return $this;
    }
    /**
     * Get PackageReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageReference()
    {
        return isset($this->PackageReference) ? $this->PackageReference : null;
    }
    /**
     * Set PackageReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageReference
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setPackageReference($packageReference = null)
    {
        // validation for constraint: string
        if (!is_null($packageReference) && !is_string($packageReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageReference, true), gettype($packageReference)), __LINE__);
        }
        if (is_null($packageReference) || (is_array($packageReference) && empty($packageReference))) {
            unset($this->PackageReference);
        } else {
            $this->PackageReference = $packageReference;
        }
        return $this;
    }
    /**
     * Get Quantities value
     * @return \Cegid\StructType\CustomerOrderLineQuantities|null
     */
    public function getQuantities()
    {
        return $this->Quantities;
    }
    /**
     * Set Quantities value
     * @param \Cegid\StructType\CustomerOrderLineQuantities $quantities
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setQuantities(\Cegid\StructType\CustomerOrderLineQuantities $quantities = null)
    {
        $this->Quantities = $quantities;
        return $this;
    }
    /**
     * Get Rank value
     * @return int|null
     */
    public function getRank()
    {
        return $this->Rank;
    }
    /**
     * Set Rank value
     * @param int $rank
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setRank($rank = null)
    {
        // validation for constraint: int
        if (!is_null($rank) && !(is_int($rank) || ctype_digit($rank))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rank, true), gettype($rank)), __LINE__);
        }
        $this->Rank = $rank;
        return $this;
    }
    /**
     * Get SalespersonId value
     * @return string|null
     */
    public function getSalespersonId()
    {
        return $this->SalespersonId;
    }
    /**
     * Set SalespersonId value
     * @param string $salespersonId
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setSalespersonId($salespersonId = null)
    {
        // validation for constraint: string
        if (!is_null($salespersonId) && !is_string($salespersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salespersonId, true), gettype($salespersonId)), __LINE__);
        }
        $this->SalespersonId = $salespersonId;
        return $this;
    }
    /**
     * Get Taxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CustomerOrderLineTaxCollection|null
     */
    public function getTaxes()
    {
        return isset($this->Taxes) ? $this->Taxes : null;
    }
    /**
     * Set Taxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CustomerOrderLineTaxCollection $taxes
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setTaxes(\Cegid\StructType\CustomerOrderLineTaxCollection $taxes = null)
    {
        if (is_null($taxes) || (is_array($taxes) && empty($taxes))) {
            unset($this->Taxes);
        } else {
            $this->Taxes = $taxes;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Cegid\EnumType\CustomerOrderLineType::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderLineType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderLineType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderLineType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Cegid\EnumType\CustomerOrderLineType::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $unitPrice
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get WarehouseId value
     * @return string|null
     */
    public function getWarehouseId()
    {
        return $this->WarehouseId;
    }
    /**
     * Set WarehouseId value
     * @param string $warehouseId
     * @return \Cegid\StructType\CustomerOrderLine
     */
    public function setWarehouseId($warehouseId = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseId) && !is_string($warehouseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseId, true), gettype($warehouseId)), __LINE__);
        }
        $this->WarehouseId = $warehouseId;
        return $this;
    }
}
