<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderHeaderOmniChannel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderHeaderOmniChannel
 * @subpackage Structs
 */
class CustomerOrderHeaderOmniChannel extends AbstractStructBase
{
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The DeliveryStoreId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DeliveryStoreId;
    /**
     * The DeliveryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryType;
    /**
     * The DeliveryWarehouseId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DeliveryWarehouseId;
    /**
     * The FollowUpStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FollowUpStatus;
    /**
     * The GiftMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderHeaderOmniChannelGiftMessage
     */
    public $GiftMessage;
    /**
     * The Tracking
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tracking;
    /**
     * The Transporter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Transporter;
    /**
     * Constructor method for CustomerOrderHeaderOmniChannel
     * @uses CustomerOrderHeaderOmniChannel::setComment()
     * @uses CustomerOrderHeaderOmniChannel::setDeliveryStoreId()
     * @uses CustomerOrderHeaderOmniChannel::setDeliveryType()
     * @uses CustomerOrderHeaderOmniChannel::setDeliveryWarehouseId()
     * @uses CustomerOrderHeaderOmniChannel::setFollowUpStatus()
     * @uses CustomerOrderHeaderOmniChannel::setGiftMessage()
     * @uses CustomerOrderHeaderOmniChannel::setTracking()
     * @uses CustomerOrderHeaderOmniChannel::setTransporter()
     * @param string $comment
     * @param string $deliveryStoreId
     * @param string $deliveryType
     * @param string $deliveryWarehouseId
     * @param string $followUpStatus
     * @param \Cegid\StructType\CustomerOrderHeaderOmniChannelGiftMessage $giftMessage
     * @param string $tracking
     * @param string $transporter
     */
    public function __construct($comment = null, $deliveryStoreId = null, $deliveryType = null, $deliveryWarehouseId = null, $followUpStatus = null, \Cegid\StructType\CustomerOrderHeaderOmniChannelGiftMessage $giftMessage = null, $tracking = null, $transporter = null)
    {
        $this
            ->setComment($comment)
            ->setDeliveryStoreId($deliveryStoreId)
            ->setDeliveryType($deliveryType)
            ->setDeliveryWarehouseId($deliveryWarehouseId)
            ->setFollowUpStatus($followUpStatus)
            ->setGiftMessage($giftMessage)
            ->setTracking($tracking)
            ->setTransporter($transporter);
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \Cegid\StructType\CustomerOrderHeaderOmniChannel
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get DeliveryStoreId value
     * @return string|null
     */
    public function getDeliveryStoreId()
    {
        return $this->DeliveryStoreId;
    }
    /**
     * Set DeliveryStoreId value
     * @param string $deliveryStoreId
     * @return \Cegid\StructType\CustomerOrderHeaderOmniChannel
     */
    public function setDeliveryStoreId($deliveryStoreId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStoreId) && !is_string($deliveryStoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryStoreId, true), gettype($deliveryStoreId)), __LINE__);
        }
        $this->DeliveryStoreId = $deliveryStoreId;
        return $this;
    }
    /**
     * Get DeliveryType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryType()
    {
        return isset($this->DeliveryType) ? $this->DeliveryType : null;
    }
    /**
     * Set DeliveryType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Cegid\EnumType\CustomerOrderDeliveryType::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderDeliveryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryType
     * @return \Cegid\StructType\CustomerOrderHeaderOmniChannel
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderDeliveryType::valueIsValid($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderDeliveryType', is_array($deliveryType) ? implode(', ', $deliveryType) : var_export($deliveryType, true), implode(', ', \Cegid\EnumType\CustomerOrderDeliveryType::getValidValues())), __LINE__);
        }
        if (is_null($deliveryType) || (is_array($deliveryType) && empty($deliveryType))) {
            unset($this->DeliveryType);
        } else {
            $this->DeliveryType = $deliveryType;
        }
        return $this;
    }
    /**
     * Get DeliveryWarehouseId value
     * @return string|null
     */
    public function getDeliveryWarehouseId()
    {
        return $this->DeliveryWarehouseId;
    }
    /**
     * Set DeliveryWarehouseId value
     * @param string $deliveryWarehouseId
     * @return \Cegid\StructType\CustomerOrderHeaderOmniChannel
     */
    public function setDeliveryWarehouseId($deliveryWarehouseId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryWarehouseId) && !is_string($deliveryWarehouseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryWarehouseId, true), gettype($deliveryWarehouseId)), __LINE__);
        }
        $this->DeliveryWarehouseId = $deliveryWarehouseId;
        return $this;
    }
    /**
     * Get FollowUpStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFollowUpStatus()
    {
        return isset($this->FollowUpStatus) ? $this->FollowUpStatus : null;
    }
    /**
     * Set FollowUpStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Cegid\EnumType\CustomerOrderFollowUpStatusAll::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderFollowUpStatusAll::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $followUpStatus
     * @return \Cegid\StructType\CustomerOrderHeaderOmniChannel
     */
    public function setFollowUpStatus($followUpStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderFollowUpStatusAll::valueIsValid($followUpStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderFollowUpStatusAll', is_array($followUpStatus) ? implode(', ', $followUpStatus) : var_export($followUpStatus, true), implode(', ', \Cegid\EnumType\CustomerOrderFollowUpStatusAll::getValidValues())), __LINE__);
        }
        if (is_null($followUpStatus) || (is_array($followUpStatus) && empty($followUpStatus))) {
            unset($this->FollowUpStatus);
        } else {
            $this->FollowUpStatus = $followUpStatus;
        }
        return $this;
    }
    /**
     * Get GiftMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CustomerOrderHeaderOmniChannelGiftMessage|null
     */
    public function getGiftMessage()
    {
        return isset($this->GiftMessage) ? $this->GiftMessage : null;
    }
    /**
     * Set GiftMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CustomerOrderHeaderOmniChannelGiftMessage $giftMessage
     * @return \Cegid\StructType\CustomerOrderHeaderOmniChannel
     */
    public function setGiftMessage(\Cegid\StructType\CustomerOrderHeaderOmniChannelGiftMessage $giftMessage = null)
    {
        if (is_null($giftMessage) || (is_array($giftMessage) && empty($giftMessage))) {
            unset($this->GiftMessage);
        } else {
            $this->GiftMessage = $giftMessage;
        }
        return $this;
    }
    /**
     * Get Tracking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTracking()
    {
        return isset($this->Tracking) ? $this->Tracking : null;
    }
    /**
     * Set Tracking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tracking
     * @return \Cegid\StructType\CustomerOrderHeaderOmniChannel
     */
    public function setTracking($tracking = null)
    {
        // validation for constraint: string
        if (!is_null($tracking) && !is_string($tracking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tracking, true), gettype($tracking)), __LINE__);
        }
        if (is_null($tracking) || (is_array($tracking) && empty($tracking))) {
            unset($this->Tracking);
        } else {
            $this->Tracking = $tracking;
        }
        return $this;
    }
    /**
     * Get Transporter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransporter()
    {
        return isset($this->Transporter) ? $this->Transporter : null;
    }
    /**
     * Set Transporter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transporter
     * @return \Cegid\StructType\CustomerOrderHeaderOmniChannel
     */
    public function setTransporter($transporter = null)
    {
        // validation for constraint: string
        if (!is_null($transporter) && !is_string($transporter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transporter, true), gettype($transporter)), __LINE__);
        }
        if (is_null($transporter) || (is_array($transporter) && empty($transporter))) {
            unset($this->Transporter);
        } else {
            $this->Transporter = $transporter;
        }
        return $this;
    }
}
