<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRequestLineProductTaxCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateRequestLineProductTaxCollection
 * @subpackage Structs
 */
class CreateRequestLineProductTaxCollection extends AbstractStructBase
{
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestLineProductTax[]
     */
    public $Tax;
    /**
     * Constructor method for CreateRequestLineProductTaxCollection
     * @uses CreateRequestLineProductTaxCollection::setTax()
     * @param \Cegid\StructType\CreateRequestLineProductTax[] $tax
     */
    public function __construct(array $tax = array())
    {
        $this
            ->setTax($tax);
    }
    /**
     * Get Tax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateRequestLineProductTax[]|null
     */
    public function getTax()
    {
        return isset($this->Tax) ? $this->Tax : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createRequestLineProductTaxCollectionTaxItem) {
            // validation for constraint: itemType
            if (!$createRequestLineProductTaxCollectionTaxItem instanceof \Cegid\StructType\CreateRequestLineProductTax) {
                $invalidValues[] = is_object($createRequestLineProductTaxCollectionTaxItem) ? get_class($createRequestLineProductTaxCollectionTaxItem) : sprintf('%s(%s)', gettype($createRequestLineProductTaxCollectionTaxItem), var_export($createRequestLineProductTaxCollectionTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \Cegid\StructType\CreateRequestLineProductTax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CreateRequestLineProductTax[] $tax
     * @return \Cegid\StructType\CreateRequestLineProductTaxCollection
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        if (is_null($tax) || (is_array($tax) && empty($tax))) {
            unset($this->Tax);
        } else {
            $this->Tax = $tax;
        }
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CreateRequestLineProductTax $item
     * @return \Cegid\StructType\CreateRequestLineProductTaxCollection
     */
    public function addToTax(\Cegid\StructType\CreateRequestLineProductTax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\CreateRequestLineProductTax) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \Cegid\StructType\CreateRequestLineProductTax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
}
