<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRequestHeaderEmployeeCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateRequestHeaderEmployeeCollection
 * @subpackage Structs
 */
class CreateRequestHeaderEmployeeCollection extends AbstractStructBase
{
    /**
     * The Employee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderEmployee[]
     */
    public $Employee;
    /**
     * Constructor method for CreateRequestHeaderEmployeeCollection
     * @uses CreateRequestHeaderEmployeeCollection::setEmployee()
     * @param \Cegid\StructType\CreateRequestHeaderEmployee[] $employee
     */
    public function __construct(array $employee = array())
    {
        $this
            ->setEmployee($employee);
    }
    /**
     * Get Employee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateRequestHeaderEmployee[]|null
     */
    public function getEmployee()
    {
        return isset($this->Employee) ? $this->Employee : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeForArrayConstraintsFromSetEmployee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createRequestHeaderEmployeeCollectionEmployeeItem) {
            // validation for constraint: itemType
            if (!$createRequestHeaderEmployeeCollectionEmployeeItem instanceof \Cegid\StructType\CreateRequestHeaderEmployee) {
                $invalidValues[] = is_object($createRequestHeaderEmployeeCollectionEmployeeItem) ? get_class($createRequestHeaderEmployeeCollectionEmployeeItem) : sprintf('%s(%s)', gettype($createRequestHeaderEmployeeCollectionEmployeeItem), var_export($createRequestHeaderEmployeeCollectionEmployeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Employee property can only contain items of type \Cegid\StructType\CreateRequestHeaderEmployee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Employee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CreateRequestHeaderEmployee[] $employee
     * @return \Cegid\StructType\CreateRequestHeaderEmployeeCollection
     */
    public function setEmployee(array $employee = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeArrayErrorMessage = self::validateEmployeeForArrayConstraintsFromSetEmployee($employee))) {
            throw new \InvalidArgumentException($employeeArrayErrorMessage, __LINE__);
        }
        if (is_null($employee) || (is_array($employee) && empty($employee))) {
            unset($this->Employee);
        } else {
            $this->Employee = $employee;
        }
        return $this;
    }
    /**
     * Add item to Employee value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CreateRequestHeaderEmployee $item
     * @return \Cegid\StructType\CreateRequestHeaderEmployeeCollection
     */
    public function addToEmployee(\Cegid\StructType\CreateRequestHeaderEmployee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\CreateRequestHeaderEmployee) {
            throw new \InvalidArgumentException(sprintf('The Employee property can only contain items of type \Cegid\StructType\CreateRequestHeaderEmployee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Employee[] = $item;
        return $this;
    }
}
