<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRequestHeaderCustomer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateRequestHeaderCustomer
 * @subpackage Structs
 */
class CreateRequestHeaderCustomer extends AbstractStructBase
{
    /**
     * The Addresses
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderCustomerAddressCollection
     */
    public $Addresses;
    /**
     * The Identifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderCustomerIdentifier
     */
    public $Identifier;
    /**
     * The TaxSystemId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxSystemId;
    /**
     * Constructor method for CreateRequestHeaderCustomer
     * @uses CreateRequestHeaderCustomer::setAddresses()
     * @uses CreateRequestHeaderCustomer::setIdentifier()
     * @uses CreateRequestHeaderCustomer::setTaxSystemId()
     * @param \Cegid\StructType\CreateRequestHeaderCustomerAddressCollection $addresses
     * @param \Cegid\StructType\CreateRequestHeaderCustomerIdentifier $identifier
     * @param string $taxSystemId
     */
    public function __construct(\Cegid\StructType\CreateRequestHeaderCustomerAddressCollection $addresses = null, \Cegid\StructType\CreateRequestHeaderCustomerIdentifier $identifier = null, $taxSystemId = null)
    {
        $this
            ->setAddresses($addresses)
            ->setIdentifier($identifier)
            ->setTaxSystemId($taxSystemId);
    }
    /**
     * Get Addresses value
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddressCollection|null
     */
    public function getAddresses()
    {
        return $this->Addresses;
    }
    /**
     * Set Addresses value
     * @param \Cegid\StructType\CreateRequestHeaderCustomerAddressCollection $addresses
     * @return \Cegid\StructType\CreateRequestHeaderCustomer
     */
    public function setAddresses(\Cegid\StructType\CreateRequestHeaderCustomerAddressCollection $addresses = null)
    {
        $this->Addresses = $addresses;
        return $this;
    }
    /**
     * Get Identifier value
     * @return \Cegid\StructType\CreateRequestHeaderCustomerIdentifier|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param \Cegid\StructType\CreateRequestHeaderCustomerIdentifier $identifier
     * @return \Cegid\StructType\CreateRequestHeaderCustomer
     */
    public function setIdentifier(\Cegid\StructType\CreateRequestHeaderCustomerIdentifier $identifier = null)
    {
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get TaxSystemId value
     * @return string|null
     */
    public function getTaxSystemId()
    {
        return $this->TaxSystemId;
    }
    /**
     * Set TaxSystemId value
     * @param string $taxSystemId
     * @return \Cegid\StructType\CreateRequestHeaderCustomer
     */
    public function setTaxSystemId($taxSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($taxSystemId) && !is_string($taxSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxSystemId, true), gettype($taxSystemId)), __LINE__);
        }
        $this->TaxSystemId = $taxSystemId;
        return $this;
    }
}
