<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRequestHeader StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateRequestHeader
 * @subpackage Structs
 */
class CreateRequestHeader extends AbstractStructBase
{
    /**
     * The CurrencyId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CurrencyId;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderCustomer
     */
    public $Customer;
    /**
     * The DeliveryDate
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DocumentDate
     * @var string
     */
    public $DocumentDate;
    /**
     * The Employees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderEmployeeCollection
     */
    public $Employees;
    /**
     * The OperationUid
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperationUid;
    /**
     * The References
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderReferences
     */
    public $References;
    /**
     * The StoreIdentifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderStoreIdentifier
     */
    public $StoreIdentifier;
    /**
     * The TaxExcluded
     * @var bool
     */
    public $TaxExcluded;
    /**
     * The UserDefined
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderUserDefined
     */
    public $UserDefined;
    /**
     * The UserFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfUserFieldForPost
     */
    public $UserFields;
    /**
     * The WarehouseIdentifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderWarehouseIdentifier
     */
    public $WarehouseIdentifier;
    /**
     * Constructor method for CreateRequestHeader
     * @uses CreateRequestHeader::setCurrencyId()
     * @uses CreateRequestHeader::setCustomer()
     * @uses CreateRequestHeader::setDeliveryDate()
     * @uses CreateRequestHeader::setDocumentDate()
     * @uses CreateRequestHeader::setEmployees()
     * @uses CreateRequestHeader::setOperationUid()
     * @uses CreateRequestHeader::setReferences()
     * @uses CreateRequestHeader::setStoreIdentifier()
     * @uses CreateRequestHeader::setTaxExcluded()
     * @uses CreateRequestHeader::setUserDefined()
     * @uses CreateRequestHeader::setUserFields()
     * @uses CreateRequestHeader::setWarehouseIdentifier()
     * @param string $currencyId
     * @param \Cegid\StructType\CreateRequestHeaderCustomer $customer
     * @param string $deliveryDate
     * @param string $documentDate
     * @param \Cegid\StructType\CreateRequestHeaderEmployeeCollection $employees
     * @param string $operationUid
     * @param \Cegid\StructType\CreateRequestHeaderReferences $references
     * @param \Cegid\StructType\CreateRequestHeaderStoreIdentifier $storeIdentifier
     * @param bool $taxExcluded
     * @param \Cegid\StructType\CreateRequestHeaderUserDefined $userDefined
     * @param \Cegid\ArrayType\ArrayOfUserFieldForPost $userFields
     * @param \Cegid\StructType\CreateRequestHeaderWarehouseIdentifier $warehouseIdentifier
     */
    public function __construct($currencyId = null, \Cegid\StructType\CreateRequestHeaderCustomer $customer = null, $deliveryDate = null, $documentDate = null, \Cegid\StructType\CreateRequestHeaderEmployeeCollection $employees = null, $operationUid = null, \Cegid\StructType\CreateRequestHeaderReferences $references = null, \Cegid\StructType\CreateRequestHeaderStoreIdentifier $storeIdentifier = null, $taxExcluded = null, \Cegid\StructType\CreateRequestHeaderUserDefined $userDefined = null, \Cegid\ArrayType\ArrayOfUserFieldForPost $userFields = null, \Cegid\StructType\CreateRequestHeaderWarehouseIdentifier $warehouseIdentifier = null)
    {
        $this
            ->setCurrencyId($currencyId)
            ->setCustomer($customer)
            ->setDeliveryDate($deliveryDate)
            ->setDocumentDate($documentDate)
            ->setEmployees($employees)
            ->setOperationUid($operationUid)
            ->setReferences($references)
            ->setStoreIdentifier($storeIdentifier)
            ->setTaxExcluded($taxExcluded)
            ->setUserDefined($userDefined)
            ->setUserFields($userFields)
            ->setWarehouseIdentifier($warehouseIdentifier);
    }
    /**
     * Get CurrencyId value
     * @return string|null
     */
    public function getCurrencyId()
    {
        return $this->CurrencyId;
    }
    /**
     * Set CurrencyId value
     * @param string $currencyId
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: string
        if (!is_null($currencyId) && !is_string($currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyId, true), gettype($currencyId)), __LINE__);
        }
        $this->CurrencyId = $currencyId;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Cegid\StructType\CreateRequestHeaderCustomer|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Cegid\StructType\CreateRequestHeaderCustomer $customer
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setCustomer(\Cegid\StructType\CreateRequestHeaderCustomer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DocumentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }
    /**
     * Set DocumentDate value
     * @param string $documentDate
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        $this->DocumentDate = $documentDate;
        return $this;
    }
    /**
     * Get Employees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateRequestHeaderEmployeeCollection|null
     */
    public function getEmployees()
    {
        return isset($this->Employees) ? $this->Employees : null;
    }
    /**
     * Set Employees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateRequestHeaderEmployeeCollection $employees
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setEmployees(\Cegid\StructType\CreateRequestHeaderEmployeeCollection $employees = null)
    {
        if (is_null($employees) || (is_array($employees) && empty($employees))) {
            unset($this->Employees);
        } else {
            $this->Employees = $employees;
        }
        return $this;
    }
    /**
     * Get OperationUid value
     * @return string|null
     */
    public function getOperationUid()
    {
        return $this->OperationUid;
    }
    /**
     * Set OperationUid value
     * @param string $operationUid
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setOperationUid($operationUid = null)
    {
        // validation for constraint: string
        if (!is_null($operationUid) && !is_string($operationUid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationUid, true), gettype($operationUid)), __LINE__);
        }
        $this->OperationUid = $operationUid;
        return $this;
    }
    /**
     * Get References value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateRequestHeaderReferences|null
     */
    public function getReferences()
    {
        return isset($this->References) ? $this->References : null;
    }
    /**
     * Set References value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateRequestHeaderReferences $references
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setReferences(\Cegid\StructType\CreateRequestHeaderReferences $references = null)
    {
        if (is_null($references) || (is_array($references) && empty($references))) {
            unset($this->References);
        } else {
            $this->References = $references;
        }
        return $this;
    }
    /**
     * Get StoreIdentifier value
     * @return \Cegid\StructType\CreateRequestHeaderStoreIdentifier|null
     */
    public function getStoreIdentifier()
    {
        return $this->StoreIdentifier;
    }
    /**
     * Set StoreIdentifier value
     * @param \Cegid\StructType\CreateRequestHeaderStoreIdentifier $storeIdentifier
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setStoreIdentifier(\Cegid\StructType\CreateRequestHeaderStoreIdentifier $storeIdentifier = null)
    {
        $this->StoreIdentifier = $storeIdentifier;
        return $this;
    }
    /**
     * Get TaxExcluded value
     * @return bool|null
     */
    public function getTaxExcluded()
    {
        return $this->TaxExcluded;
    }
    /**
     * Set TaxExcluded value
     * @param bool $taxExcluded
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setTaxExcluded($taxExcluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxExcluded) && !is_bool($taxExcluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxExcluded, true), gettype($taxExcluded)), __LINE__);
        }
        $this->TaxExcluded = $taxExcluded;
        return $this;
    }
    /**
     * Get UserDefined value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateRequestHeaderUserDefined|null
     */
    public function getUserDefined()
    {
        return isset($this->UserDefined) ? $this->UserDefined : null;
    }
    /**
     * Set UserDefined value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateRequestHeaderUserDefined $userDefined
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setUserDefined(\Cegid\StructType\CreateRequestHeaderUserDefined $userDefined = null)
    {
        if (is_null($userDefined) || (is_array($userDefined) && empty($userDefined))) {
            unset($this->UserDefined);
        } else {
            $this->UserDefined = $userDefined;
        }
        return $this;
    }
    /**
     * Get UserFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\ArrayType\ArrayOfUserFieldForPost|null
     */
    public function getUserFields()
    {
        return isset($this->UserFields) ? $this->UserFields : null;
    }
    /**
     * Set UserFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\ArrayType\ArrayOfUserFieldForPost $userFields
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setUserFields(\Cegid\ArrayType\ArrayOfUserFieldForPost $userFields = null)
    {
        if (is_null($userFields) || (is_array($userFields) && empty($userFields))) {
            unset($this->UserFields);
        } else {
            $this->UserFields = $userFields;
        }
        return $this;
    }
    /**
     * Get WarehouseIdentifier value
     * @return \Cegid\StructType\CreateRequestHeaderWarehouseIdentifier|null
     */
    public function getWarehouseIdentifier()
    {
        return $this->WarehouseIdentifier;
    }
    /**
     * Set WarehouseIdentifier value
     * @param \Cegid\StructType\CreateRequestHeaderWarehouseIdentifier $warehouseIdentifier
     * @return \Cegid\StructType\CreateRequestHeader
     */
    public function setWarehouseIdentifier(\Cegid\StructType\CreateRequestHeaderWarehouseIdentifier $warehouseIdentifier = null)
    {
        $this->WarehouseIdentifier = $warehouseIdentifier;
        return $this;
    }
}
