<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateFromRequestPaymentCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateFromRequestPaymentCollection
 * @subpackage Structs
 */
class CreateFromRequestPaymentCollection extends AbstractStructBase
{
    /**
     * The Payment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestPayment[]
     */
    public $Payment;
    /**
     * Constructor method for CreateFromRequestPaymentCollection
     * @uses CreateFromRequestPaymentCollection::setPayment()
     * @param \Cegid\StructType\CreateFromRequestPayment[] $payment
     */
    public function __construct(array $payment = array())
    {
        $this
            ->setPayment($payment);
    }
    /**
     * Get Payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateFromRequestPayment[]|null
     */
    public function getPayment()
    {
        return isset($this->Payment) ? $this->Payment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentForArrayConstraintsFromSetPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createFromRequestPaymentCollectionPaymentItem) {
            // validation for constraint: itemType
            if (!$createFromRequestPaymentCollectionPaymentItem instanceof \Cegid\StructType\CreateFromRequestPayment) {
                $invalidValues[] = is_object($createFromRequestPaymentCollectionPaymentItem) ? get_class($createFromRequestPaymentCollectionPaymentItem) : sprintf('%s(%s)', gettype($createFromRequestPaymentCollectionPaymentItem), var_export($createFromRequestPaymentCollectionPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payment property can only contain items of type \Cegid\StructType\CreateFromRequestPayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CreateFromRequestPayment[] $payment
     * @return \Cegid\StructType\CreateFromRequestPaymentCollection
     */
    public function setPayment(array $payment = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentArrayErrorMessage = self::validatePaymentForArrayConstraintsFromSetPayment($payment))) {
            throw new \InvalidArgumentException($paymentArrayErrorMessage, __LINE__);
        }
        if (is_null($payment) || (is_array($payment) && empty($payment))) {
            unset($this->Payment);
        } else {
            $this->Payment = $payment;
        }
        return $this;
    }
    /**
     * Add item to Payment value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CreateFromRequestPayment $item
     * @return \Cegid\StructType\CreateFromRequestPaymentCollection
     */
    public function addToPayment(\Cegid\StructType\CreateFromRequestPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\CreateFromRequestPayment) {
            throw new \InvalidArgumentException(sprintf('The Payment property can only contain items of type \Cegid\StructType\CreateFromRequestPayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payment[] = $item;
        return $this;
    }
}
