<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateFromRequestHeader StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateFromRequestHeader
 * @subpackage Structs
 */
class CreateFromRequestHeader extends AbstractStructBase
{
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceId;
    /**
     * The DisableMergeLines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisableMergeLines;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The FollowUpReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FollowUpReference;
    /**
     * The InternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalReference;
    /**
     * The MovementReasonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovementReasonId;
    /**
     * The OperationUid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationUid;
    /**
     * The OriginalDocumentIdentifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestHeaderOriginalDocumentIdentifier
     */
    public $OriginalDocumentIdentifier;
    /**
     * The RemainderManagement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestHeaderRemainderManagement
     */
    public $RemainderManagement;
    /**
     * The SalesPersonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesPersonId;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The UserDefinedDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestHeaderUserDefinedDateCollection
     */
    public $UserDefinedDates;
    /**
     * The UserDefinedTableCustomers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCustomerCollection
     */
    public $UserDefinedTableCustomers;
    /**
     * The UserDefinedTables
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCollection
     */
    public $UserDefinedTables;
    /**
     * The UserFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestHeaderUserFieldCollection
     */
    public $UserFields;
    /**
     * The WarehouseId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehouseId;
    /**
     * Constructor method for CreateFromRequestHeader
     * @uses CreateFromRequestHeader::setDate()
     * @uses CreateFromRequestHeader::setDeviceId()
     * @uses CreateFromRequestHeader::setDisableMergeLines()
     * @uses CreateFromRequestHeader::setExternalReference()
     * @uses CreateFromRequestHeader::setFollowUpReference()
     * @uses CreateFromRequestHeader::setInternalReference()
     * @uses CreateFromRequestHeader::setMovementReasonId()
     * @uses CreateFromRequestHeader::setOperationUid()
     * @uses CreateFromRequestHeader::setOriginalDocumentIdentifier()
     * @uses CreateFromRequestHeader::setRemainderManagement()
     * @uses CreateFromRequestHeader::setSalesPersonId()
     * @uses CreateFromRequestHeader::setType()
     * @uses CreateFromRequestHeader::setUserDefinedDates()
     * @uses CreateFromRequestHeader::setUserDefinedTableCustomers()
     * @uses CreateFromRequestHeader::setUserDefinedTables()
     * @uses CreateFromRequestHeader::setUserFields()
     * @uses CreateFromRequestHeader::setWarehouseId()
     * @param string $date
     * @param string $deviceId
     * @param bool $disableMergeLines
     * @param string $externalReference
     * @param string $followUpReference
     * @param string $internalReference
     * @param string $movementReasonId
     * @param string $operationUid
     * @param \Cegid\StructType\CreateFromRequestHeaderOriginalDocumentIdentifier $originalDocumentIdentifier
     * @param \Cegid\StructType\CreateFromRequestHeaderRemainderManagement $remainderManagement
     * @param string $salesPersonId
     * @param string $type
     * @param \Cegid\StructType\CreateFromRequestHeaderUserDefinedDateCollection $userDefinedDates
     * @param \Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCustomerCollection $userDefinedTableCustomers
     * @param \Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCollection $userDefinedTables
     * @param \Cegid\StructType\CreateFromRequestHeaderUserFieldCollection $userFields
     * @param string $warehouseId
     */
    public function __construct($date = null, $deviceId = null, $disableMergeLines = null, $externalReference = null, $followUpReference = null, $internalReference = null, $movementReasonId = null, $operationUid = null, \Cegid\StructType\CreateFromRequestHeaderOriginalDocumentIdentifier $originalDocumentIdentifier = null, \Cegid\StructType\CreateFromRequestHeaderRemainderManagement $remainderManagement = null, $salesPersonId = null, $type = null, \Cegid\StructType\CreateFromRequestHeaderUserDefinedDateCollection $userDefinedDates = null, \Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCustomerCollection $userDefinedTableCustomers = null, \Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCollection $userDefinedTables = null, \Cegid\StructType\CreateFromRequestHeaderUserFieldCollection $userFields = null, $warehouseId = null)
    {
        $this
            ->setDate($date)
            ->setDeviceId($deviceId)
            ->setDisableMergeLines($disableMergeLines)
            ->setExternalReference($externalReference)
            ->setFollowUpReference($followUpReference)
            ->setInternalReference($internalReference)
            ->setMovementReasonId($movementReasonId)
            ->setOperationUid($operationUid)
            ->setOriginalDocumentIdentifier($originalDocumentIdentifier)
            ->setRemainderManagement($remainderManagement)
            ->setSalesPersonId($salesPersonId)
            ->setType($type)
            ->setUserDefinedDates($userDefinedDates)
            ->setUserDefinedTableCustomers($userDefinedTableCustomers)
            ->setUserDefinedTables($userDefinedTables)
            ->setUserFields($userFields)
            ->setWarehouseId($warehouseId);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get DeviceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceId()
    {
        return isset($this->DeviceId) ? $this->DeviceId : null;
    }
    /**
     * Set DeviceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceId
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: string
        if (!is_null($deviceId) && !is_string($deviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        if (is_null($deviceId) || (is_array($deviceId) && empty($deviceId))) {
            unset($this->DeviceId);
        } else {
            $this->DeviceId = $deviceId;
        }
        return $this;
    }
    /**
     * Get DisableMergeLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisableMergeLines()
    {
        return isset($this->DisableMergeLines) ? $this->DisableMergeLines : null;
    }
    /**
     * Set DisableMergeLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $disableMergeLines
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setDisableMergeLines($disableMergeLines = null)
    {
        // validation for constraint: boolean
        if (!is_null($disableMergeLines) && !is_bool($disableMergeLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disableMergeLines, true), gettype($disableMergeLines)), __LINE__);
        }
        if (is_null($disableMergeLines) || (is_array($disableMergeLines) && empty($disableMergeLines))) {
            unset($this->DisableMergeLines);
        } else {
            $this->DisableMergeLines = $disableMergeLines;
        }
        return $this;
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get FollowUpReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFollowUpReference()
    {
        return isset($this->FollowUpReference) ? $this->FollowUpReference : null;
    }
    /**
     * Set FollowUpReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $followUpReference
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setFollowUpReference($followUpReference = null)
    {
        // validation for constraint: string
        if (!is_null($followUpReference) && !is_string($followUpReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($followUpReference, true), gettype($followUpReference)), __LINE__);
        }
        if (is_null($followUpReference) || (is_array($followUpReference) && empty($followUpReference))) {
            unset($this->FollowUpReference);
        } else {
            $this->FollowUpReference = $followUpReference;
        }
        return $this;
    }
    /**
     * Get InternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalReference()
    {
        return isset($this->InternalReference) ? $this->InternalReference : null;
    }
    /**
     * Set InternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalReference
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setInternalReference($internalReference = null)
    {
        // validation for constraint: string
        if (!is_null($internalReference) && !is_string($internalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalReference, true), gettype($internalReference)), __LINE__);
        }
        if (is_null($internalReference) || (is_array($internalReference) && empty($internalReference))) {
            unset($this->InternalReference);
        } else {
            $this->InternalReference = $internalReference;
        }
        return $this;
    }
    /**
     * Get MovementReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovementReasonId()
    {
        return isset($this->MovementReasonId) ? $this->MovementReasonId : null;
    }
    /**
     * Set MovementReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $movementReasonId
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setMovementReasonId($movementReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($movementReasonId) && !is_string($movementReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($movementReasonId, true), gettype($movementReasonId)), __LINE__);
        }
        if (is_null($movementReasonId) || (is_array($movementReasonId) && empty($movementReasonId))) {
            unset($this->MovementReasonId);
        } else {
            $this->MovementReasonId = $movementReasonId;
        }
        return $this;
    }
    /**
     * Get OperationUid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationUid()
    {
        return isset($this->OperationUid) ? $this->OperationUid : null;
    }
    /**
     * Set OperationUid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationUid
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setOperationUid($operationUid = null)
    {
        // validation for constraint: string
        if (!is_null($operationUid) && !is_string($operationUid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationUid, true), gettype($operationUid)), __LINE__);
        }
        if (is_null($operationUid) || (is_array($operationUid) && empty($operationUid))) {
            unset($this->OperationUid);
        } else {
            $this->OperationUid = $operationUid;
        }
        return $this;
    }
    /**
     * Get OriginalDocumentIdentifier value
     * @return \Cegid\StructType\CreateFromRequestHeaderOriginalDocumentIdentifier|null
     */
    public function getOriginalDocumentIdentifier()
    {
        return $this->OriginalDocumentIdentifier;
    }
    /**
     * Set OriginalDocumentIdentifier value
     * @param \Cegid\StructType\CreateFromRequestHeaderOriginalDocumentIdentifier $originalDocumentIdentifier
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setOriginalDocumentIdentifier(\Cegid\StructType\CreateFromRequestHeaderOriginalDocumentIdentifier $originalDocumentIdentifier = null)
    {
        $this->OriginalDocumentIdentifier = $originalDocumentIdentifier;
        return $this;
    }
    /**
     * Get RemainderManagement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateFromRequestHeaderRemainderManagement|null
     */
    public function getRemainderManagement()
    {
        return isset($this->RemainderManagement) ? $this->RemainderManagement : null;
    }
    /**
     * Set RemainderManagement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateFromRequestHeaderRemainderManagement $remainderManagement
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setRemainderManagement(\Cegid\StructType\CreateFromRequestHeaderRemainderManagement $remainderManagement = null)
    {
        if (is_null($remainderManagement) || (is_array($remainderManagement) && empty($remainderManagement))) {
            unset($this->RemainderManagement);
        } else {
            $this->RemainderManagement = $remainderManagement;
        }
        return $this;
    }
    /**
     * Get SalesPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesPersonId()
    {
        return isset($this->SalesPersonId) ? $this->SalesPersonId : null;
    }
    /**
     * Set SalesPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesPersonId
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setSalesPersonId($salesPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($salesPersonId) && !is_string($salesPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesPersonId, true), gettype($salesPersonId)), __LINE__);
        }
        if (is_null($salesPersonId) || (is_array($salesPersonId) && empty($salesPersonId))) {
            unset($this->SalesPersonId);
        } else {
            $this->SalesPersonId = $salesPersonId;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Cegid\EnumType\CustomerOrderDocumentTypeCreat::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderDocumentTypeCreat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderDocumentTypeCreat::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderDocumentTypeCreat', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Cegid\EnumType\CustomerOrderDocumentTypeCreat::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get UserDefinedDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateFromRequestHeaderUserDefinedDateCollection|null
     */
    public function getUserDefinedDates()
    {
        return isset($this->UserDefinedDates) ? $this->UserDefinedDates : null;
    }
    /**
     * Set UserDefinedDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateFromRequestHeaderUserDefinedDateCollection $userDefinedDates
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setUserDefinedDates(\Cegid\StructType\CreateFromRequestHeaderUserDefinedDateCollection $userDefinedDates = null)
    {
        if (is_null($userDefinedDates) || (is_array($userDefinedDates) && empty($userDefinedDates))) {
            unset($this->UserDefinedDates);
        } else {
            $this->UserDefinedDates = $userDefinedDates;
        }
        return $this;
    }
    /**
     * Get UserDefinedTableCustomers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCustomerCollection|null
     */
    public function getUserDefinedTableCustomers()
    {
        return isset($this->UserDefinedTableCustomers) ? $this->UserDefinedTableCustomers : null;
    }
    /**
     * Set UserDefinedTableCustomers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCustomerCollection $userDefinedTableCustomers
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setUserDefinedTableCustomers(\Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCustomerCollection $userDefinedTableCustomers = null)
    {
        if (is_null($userDefinedTableCustomers) || (is_array($userDefinedTableCustomers) && empty($userDefinedTableCustomers))) {
            unset($this->UserDefinedTableCustomers);
        } else {
            $this->UserDefinedTableCustomers = $userDefinedTableCustomers;
        }
        return $this;
    }
    /**
     * Get UserDefinedTables value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCollection|null
     */
    public function getUserDefinedTables()
    {
        return isset($this->UserDefinedTables) ? $this->UserDefinedTables : null;
    }
    /**
     * Set UserDefinedTables value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCollection $userDefinedTables
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setUserDefinedTables(\Cegid\StructType\CreateFromRequestHeaderUserDefinedTableCollection $userDefinedTables = null)
    {
        if (is_null($userDefinedTables) || (is_array($userDefinedTables) && empty($userDefinedTables))) {
            unset($this->UserDefinedTables);
        } else {
            $this->UserDefinedTables = $userDefinedTables;
        }
        return $this;
    }
    /**
     * Get UserFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateFromRequestHeaderUserFieldCollection|null
     */
    public function getUserFields()
    {
        return isset($this->UserFields) ? $this->UserFields : null;
    }
    /**
     * Set UserFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateFromRequestHeaderUserFieldCollection $userFields
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setUserFields(\Cegid\StructType\CreateFromRequestHeaderUserFieldCollection $userFields = null)
    {
        if (is_null($userFields) || (is_array($userFields) && empty($userFields))) {
            unset($this->UserFields);
        } else {
            $this->UserFields = $userFields;
        }
        return $this;
    }
    /**
     * Get WarehouseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouseId()
    {
        return isset($this->WarehouseId) ? $this->WarehouseId : null;
    }
    /**
     * Set WarehouseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouseId
     * @return \Cegid\StructType\CreateFromRequestHeader
     */
    public function setWarehouseId($warehouseId = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseId) && !is_string($warehouseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseId, true), gettype($warehouseId)), __LINE__);
        }
        if (is_null($warehouseId) || (is_array($warehouseId) && empty($warehouseId))) {
            unset($this->WarehouseId);
        } else {
            $this->WarehouseId = $warehouseId;
        }
        return $this;
    }
}
