<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateFrom2RequestLine StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateFrom2RequestLine
 * @subpackage Structs
 */
class CreateFrom2RequestLine extends AbstractStructBase
{
    /**
     * The AdditionalDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdditionalDescription;
    /**
     * The ItemIdentifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CreateFrom2RequestLineItemIdentifier
     */
    public $ItemIdentifier;
    /**
     * The Quantity
     * @var float
     */
    public $Quantity;
    /**
     * The References
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateFrom2RequestLineReferences
     */
    public $References;
    /**
     * The SalespersonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalespersonId;
    /**
     * The SerialNumberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerialNumberId;
    /**
     * The WarehouseId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $WarehouseId;
    /**
     * Constructor method for CreateFrom2RequestLine
     * @uses CreateFrom2RequestLine::setAdditionalDescription()
     * @uses CreateFrom2RequestLine::setItemIdentifier()
     * @uses CreateFrom2RequestLine::setQuantity()
     * @uses CreateFrom2RequestLine::setReferences()
     * @uses CreateFrom2RequestLine::setSalespersonId()
     * @uses CreateFrom2RequestLine::setSerialNumberId()
     * @uses CreateFrom2RequestLine::setWarehouseId()
     * @param string $additionalDescription
     * @param \Cegid\StructType\CreateFrom2RequestLineItemIdentifier $itemIdentifier
     * @param float $quantity
     * @param \Cegid\StructType\CreateFrom2RequestLineReferences $references
     * @param string $salespersonId
     * @param string $serialNumberId
     * @param string $warehouseId
     */
    public function __construct($additionalDescription = null, \Cegid\StructType\CreateFrom2RequestLineItemIdentifier $itemIdentifier = null, $quantity = null, \Cegid\StructType\CreateFrom2RequestLineReferences $references = null, $salespersonId = null, $serialNumberId = null, $warehouseId = null)
    {
        $this
            ->setAdditionalDescription($additionalDescription)
            ->setItemIdentifier($itemIdentifier)
            ->setQuantity($quantity)
            ->setReferences($references)
            ->setSalespersonId($salespersonId)
            ->setSerialNumberId($serialNumberId)
            ->setWarehouseId($warehouseId);
    }
    /**
     * Get AdditionalDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalDescription()
    {
        return isset($this->AdditionalDescription) ? $this->AdditionalDescription : null;
    }
    /**
     * Set AdditionalDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalDescription
     * @return \Cegid\StructType\CreateFrom2RequestLine
     */
    public function setAdditionalDescription($additionalDescription = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDescription) && !is_string($additionalDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDescription, true), gettype($additionalDescription)), __LINE__);
        }
        if (is_null($additionalDescription) || (is_array($additionalDescription) && empty($additionalDescription))) {
            unset($this->AdditionalDescription);
        } else {
            $this->AdditionalDescription = $additionalDescription;
        }
        return $this;
    }
    /**
     * Get ItemIdentifier value
     * @return \Cegid\StructType\CreateFrom2RequestLineItemIdentifier|null
     */
    public function getItemIdentifier()
    {
        return $this->ItemIdentifier;
    }
    /**
     * Set ItemIdentifier value
     * @param \Cegid\StructType\CreateFrom2RequestLineItemIdentifier $itemIdentifier
     * @return \Cegid\StructType\CreateFrom2RequestLine
     */
    public function setItemIdentifier(\Cegid\StructType\CreateFrom2RequestLineItemIdentifier $itemIdentifier = null)
    {
        $this->ItemIdentifier = $itemIdentifier;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \Cegid\StructType\CreateFrom2RequestLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get References value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateFrom2RequestLineReferences|null
     */
    public function getReferences()
    {
        return isset($this->References) ? $this->References : null;
    }
    /**
     * Set References value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateFrom2RequestLineReferences $references
     * @return \Cegid\StructType\CreateFrom2RequestLine
     */
    public function setReferences(\Cegid\StructType\CreateFrom2RequestLineReferences $references = null)
    {
        if (is_null($references) || (is_array($references) && empty($references))) {
            unset($this->References);
        } else {
            $this->References = $references;
        }
        return $this;
    }
    /**
     * Get SalespersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalespersonId()
    {
        return isset($this->SalespersonId) ? $this->SalespersonId : null;
    }
    /**
     * Set SalespersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salespersonId
     * @return \Cegid\StructType\CreateFrom2RequestLine
     */
    public function setSalespersonId($salespersonId = null)
    {
        // validation for constraint: string
        if (!is_null($salespersonId) && !is_string($salespersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salespersonId, true), gettype($salespersonId)), __LINE__);
        }
        if (is_null($salespersonId) || (is_array($salespersonId) && empty($salespersonId))) {
            unset($this->SalespersonId);
        } else {
            $this->SalespersonId = $salespersonId;
        }
        return $this;
    }
    /**
     * Get SerialNumberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerialNumberId()
    {
        return isset($this->SerialNumberId) ? $this->SerialNumberId : null;
    }
    /**
     * Set SerialNumberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serialNumberId
     * @return \Cegid\StructType\CreateFrom2RequestLine
     */
    public function setSerialNumberId($serialNumberId = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumberId) && !is_string($serialNumberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumberId, true), gettype($serialNumberId)), __LINE__);
        }
        if (is_null($serialNumberId) || (is_array($serialNumberId) && empty($serialNumberId))) {
            unset($this->SerialNumberId);
        } else {
            $this->SerialNumberId = $serialNumberId;
        }
        return $this;
    }
    /**
     * Get WarehouseId value
     * @return string|null
     */
    public function getWarehouseId()
    {
        return $this->WarehouseId;
    }
    /**
     * Set WarehouseId value
     * @param string $warehouseId
     * @return \Cegid\StructType\CreateFrom2RequestLine
     */
    public function setWarehouseId($warehouseId = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseId) && !is_string($warehouseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseId, true), gettype($warehouseId)), __LINE__);
        }
        $this->WarehouseId = $warehouseId;
        return $this;
    }
}
