<?php

namespace Cegid\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerOrder ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomerOrder
 * @subpackage Arrays
 */
class ArrayOfCustomerOrder extends AbstractStructArrayBase
{
    /**
     * The CustomerOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrder[]
     */
    public $CustomerOrder;
    /**
     * Constructor method for ArrayOfCustomerOrder
     * @uses ArrayOfCustomerOrder::setCustomerOrder()
     * @param \Cegid\StructType\CustomerOrder[] $customerOrder
     */
    public function __construct(array $customerOrder = array())
    {
        $this
            ->setCustomerOrder($customerOrder);
    }
    /**
     * Get CustomerOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CustomerOrder[]|null
     */
    public function getCustomerOrder()
    {
        return isset($this->CustomerOrder) ? $this->CustomerOrder : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerOrderForArrayConstraintsFromSetCustomerOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerOrderCustomerOrderItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerOrderCustomerOrderItem instanceof \Cegid\StructType\CustomerOrder) {
                $invalidValues[] = is_object($arrayOfCustomerOrderCustomerOrderItem) ? get_class($arrayOfCustomerOrderCustomerOrderItem) : sprintf('%s(%s)', gettype($arrayOfCustomerOrderCustomerOrderItem), var_export($arrayOfCustomerOrderCustomerOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerOrder property can only contain items of type \Cegid\StructType\CustomerOrder, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CustomerOrder[] $customerOrder
     * @return \Cegid\ArrayType\ArrayOfCustomerOrder
     */
    public function setCustomerOrder(array $customerOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($customerOrderArrayErrorMessage = self::validateCustomerOrderForArrayConstraintsFromSetCustomerOrder($customerOrder))) {
            throw new \InvalidArgumentException($customerOrderArrayErrorMessage, __LINE__);
        }
        if (is_null($customerOrder) || (is_array($customerOrder) && empty($customerOrder))) {
            unset($this->CustomerOrder);
        } else {
            $this->CustomerOrder = $customerOrder;
        }
        return $this;
    }
    /**
     * Add item to CustomerOrder value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CustomerOrder $item
     * @return \Cegid\ArrayType\ArrayOfCustomerOrder
     */
    public function addToCustomerOrder(\Cegid\StructType\CustomerOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\CustomerOrder) {
            throw new \InvalidArgumentException(sprintf('The CustomerOrder property can only contain items of type \Cegid\StructType\CustomerOrder, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerOrder[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Cegid\StructType\CustomerOrder|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Cegid\StructType\CustomerOrder|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Cegid\StructType\CustomerOrder|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Cegid\StructType\CustomerOrder|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Cegid\StructType\CustomerOrder|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerOrder
     */
    public function getAttributeName()
    {
        return 'CustomerOrder';
    }
}
