<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelloWorldResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Méthode HelloWorld pour valider l'accès au Web Service depuis tout client HTTP très léger via Javascript par exemple
 * @subpackage Structs
 */
class HelloWorldResponse extends AbstractStructBase
{
    /**
     * The HelloWorldResult
     * Meta information extracted from the WSDL
     * - documentation: Renvoie le texte saisi en entrée, concaténé de la phrase 'Hello You'
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HelloWorldResult;
    /**
     * Constructor method for HelloWorldResponse
     * @uses HelloWorldResponse::setHelloWorldResult()
     * @param string $helloWorldResult
     */
    public function __construct($helloWorldResult = null)
    {
        $this
            ->setHelloWorldResult($helloWorldResult);
    }
    /**
     * Get HelloWorldResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHelloWorldResult()
    {
        return isset($this->HelloWorldResult) ? $this->HelloWorldResult : null;
    }
    /**
     * Set HelloWorldResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $helloWorldResult
     * @return \Cegid\StructType\HelloWorldResponse
     */
    public function setHelloWorldResult($helloWorldResult = null)
    {
        // validation for constraint: string
        if (!is_null($helloWorldResult) && !is_string($helloWorldResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($helloWorldResult, true), gettype($helloWorldResult)), __LINE__);
        }
        if (is_null($helloWorldResult) || (is_array($helloWorldResult) && empty($helloWorldResult))) {
            unset($this->HelloWorldResult);
        } else {
            $this->HelloWorldResult = $helloWorldResult;
        }
        return $this;
    }
}
