<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelloWorld StructType
 * Meta information extracted from the WSDL
 * - documentation: Méthode HelloWorld pour valider l'accès au Web Service depuis tout client HTTP très léger via Javascript par exemple
 * @subpackage Structs
 */
class HelloWorld extends AbstractStructBase
{
    /**
     * The text
     * Meta information extracted from the WSDL
     * - documentation: Texte à passer pour tester la consommation.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $text;
    /**
     * The clientContext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\RetailContext
     */
    public $clientContext;
    /**
     * Constructor method for HelloWorld
     * @uses HelloWorld::setText()
     * @uses HelloWorld::setClientContext()
     * @param string $text
     * @param \Cegid\StructType\RetailContext $clientContext
     */
    public function __construct($text = null, \Cegid\StructType\RetailContext $clientContext = null)
    {
        $this
            ->setText($text)
            ->setClientContext($clientContext);
    }
    /**
     * Get text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->text) ? $this->text : null;
    }
    /**
     * Set text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \Cegid\StructType\HelloWorld
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->text);
        } else {
            $this->text = $text;
        }
        return $this;
    }
    /**
     * Get clientContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\RetailContext|null
     */
    public function getClientContext()
    {
        return isset($this->clientContext) ? $this->clientContext : null;
    }
    /**
     * Set clientContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\RetailContext $clientContext
     * @return \Cegid\StructType\HelloWorld
     */
    public function setClientContext(\Cegid\StructType\RetailContext $clientContext = null)
    {
        if (is_null($clientContext) || (is_array($clientContext) && empty($clientContext))) {
            unset($this->clientContext);
        } else {
            $this->clientContext = $clientContext;
        }
        return $this;
    }
}
