<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDetailRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetDetailRequest
 * @subpackage Structs
 */
class GetDetailRequest extends AbstractStructBase
{
    /**
     * The Fields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfFieldsType
     */
    public $Fields;
    /**
     * The Number
     * @var int
     */
    public $Number;
    /**
     * The Stub
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Stub;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for GetDetailRequest
     * @uses GetDetailRequest::setFields()
     * @uses GetDetailRequest::setNumber()
     * @uses GetDetailRequest::setStub()
     * @uses GetDetailRequest::setType()
     * @param \Cegid\ArrayType\ArrayOfFieldsType $fields
     * @param int $number
     * @param string $stub
     * @param string $type
     */
    public function __construct(\Cegid\ArrayType\ArrayOfFieldsType $fields = null, $number = null, $stub = null, $type = null)
    {
        $this
            ->setFields($fields)
            ->setNumber($number)
            ->setStub($stub)
            ->setType($type);
    }
    /**
     * Get Fields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\ArrayType\ArrayOfFieldsType|null
     */
    public function getFields()
    {
        return isset($this->Fields) ? $this->Fields : null;
    }
    /**
     * Set Fields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\ArrayType\ArrayOfFieldsType $fields
     * @return \Cegid\StructType\GetDetailRequest
     */
    public function setFields(\Cegid\ArrayType\ArrayOfFieldsType $fields = null)
    {
        if (is_null($fields) || (is_array($fields) && empty($fields))) {
            unset($this->Fields);
        } else {
            $this->Fields = $fields;
        }
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Cegid\StructType\GetDetailRequest
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Stub value
     * @return string|null
     */
    public function getStub()
    {
        return $this->Stub;
    }
    /**
     * Set Stub value
     * @param string $stub
     * @return \Cegid\StructType\GetDetailRequest
     */
    public function setStub($stub = null)
    {
        // validation for constraint: string
        if (!is_null($stub) && !is_string($stub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stub, true), gettype($stub)), __LINE__);
        }
        $this->Stub = $stub;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Cegid\EnumType\CustomerOrderDocumentTypeGet::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderDocumentTypeGet::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Cegid\StructType\GetDetailRequest
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderDocumentTypeGet::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderDocumentTypeGet', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Cegid\EnumType\CustomerOrderDocumentTypeGet::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
