<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderLineItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderLineItem
 * @subpackage Structs
 */
class CustomerOrderLineItem extends AbstractStructBase
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CatalogReference
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CatalogReference;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The SerialNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SerialNumber;
    /**
     * Constructor method for CustomerOrderLineItem
     * @uses CustomerOrderLineItem::setBarcode()
     * @uses CustomerOrderLineItem::setCatalogReference()
     * @uses CustomerOrderLineItem::setCode()
     * @uses CustomerOrderLineItem::setId()
     * @uses CustomerOrderLineItem::setSerialNumber()
     * @param string $barcode
     * @param string $catalogReference
     * @param string $code
     * @param string $id
     * @param string $serialNumber
     */
    public function __construct($barcode = null, $catalogReference = null, $code = null, $id = null, $serialNumber = null)
    {
        $this
            ->setBarcode($barcode)
            ->setCatalogReference($catalogReference)
            ->setCode($code)
            ->setId($id)
            ->setSerialNumber($serialNumber);
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \Cegid\StructType\CustomerOrderLineItem
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get CatalogReference value
     * @return string|null
     */
    public function getCatalogReference()
    {
        return $this->CatalogReference;
    }
    /**
     * Set CatalogReference value
     * @param string $catalogReference
     * @return \Cegid\StructType\CustomerOrderLineItem
     */
    public function setCatalogReference($catalogReference = null)
    {
        // validation for constraint: string
        if (!is_null($catalogReference) && !is_string($catalogReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalogReference, true), gettype($catalogReference)), __LINE__);
        }
        $this->CatalogReference = $catalogReference;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Cegid\StructType\CustomerOrderLineItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Cegid\StructType\CustomerOrderLineItem
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \Cegid\StructType\CustomerOrderLineItem
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
}
