<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderHeader StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderHeader
 * @subpackage Structs
 */
class CustomerOrderHeader extends AbstractStructBase
{
    /**
     * The Active
     * @var bool
     */
    public $Active;
    /**
     * The Addresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfAddress
     */
    public $Addresses;
    /**
     * The CancelStatus
     * @var string
     */
    public $CancelStatus;
    /**
     * The CurrencyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyId;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderHeaderCustomer
     */
    public $Customer;
    /**
     * The DeliveryDate
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DocumentDate
     * @var string
     */
    public $DocumentDate;
    /**
     * The DocumentKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderHeaderDocumentKey
     */
    public $DocumentKey;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The MovementReasonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovementReasonId;
    /**
     * The OmniChannel
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderHeaderOmniChannel
     */
    public $OmniChannel;
    /**
     * The References
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderHeaderReferences
     */
    public $References;
    /**
     * The SalespersonId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SalespersonId;
    /**
     * The StoreId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StoreId;
    /**
     * The TaxIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TaxIncluded;
    /**
     * The UserDefinedTables
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfUserDefinedTable
     */
    public $UserDefinedTables;
    /**
     * The UserFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfUserField
     */
    public $UserFields;
    /**
     * The VisaStatus
     * @var string
     */
    public $VisaStatus;
    /**
     * Constructor method for CustomerOrderHeader
     * @uses CustomerOrderHeader::setActive()
     * @uses CustomerOrderHeader::setAddresses()
     * @uses CustomerOrderHeader::setCancelStatus()
     * @uses CustomerOrderHeader::setCurrencyId()
     * @uses CustomerOrderHeader::setCustomer()
     * @uses CustomerOrderHeader::setDeliveryDate()
     * @uses CustomerOrderHeader::setDocumentDate()
     * @uses CustomerOrderHeader::setDocumentKey()
     * @uses CustomerOrderHeader::setEffectiveDate()
     * @uses CustomerOrderHeader::setExpiryDate()
     * @uses CustomerOrderHeader::setMovementReasonId()
     * @uses CustomerOrderHeader::setOmniChannel()
     * @uses CustomerOrderHeader::setReferences()
     * @uses CustomerOrderHeader::setSalespersonId()
     * @uses CustomerOrderHeader::setStoreId()
     * @uses CustomerOrderHeader::setTaxIncluded()
     * @uses CustomerOrderHeader::setUserDefinedTables()
     * @uses CustomerOrderHeader::setUserFields()
     * @uses CustomerOrderHeader::setVisaStatus()
     * @param bool $active
     * @param \Cegid\ArrayType\ArrayOfAddress $addresses
     * @param string $cancelStatus
     * @param string $currencyId
     * @param \Cegid\StructType\CustomerOrderHeaderCustomer $customer
     * @param string $deliveryDate
     * @param string $documentDate
     * @param \Cegid\StructType\CustomerOrderHeaderDocumentKey $documentKey
     * @param string $effectiveDate
     * @param string $expiryDate
     * @param string $movementReasonId
     * @param \Cegid\StructType\CustomerOrderHeaderOmniChannel $omniChannel
     * @param \Cegid\StructType\CustomerOrderHeaderReferences $references
     * @param string $salespersonId
     * @param string $storeId
     * @param bool $taxIncluded
     * @param \Cegid\ArrayType\ArrayOfUserDefinedTable $userDefinedTables
     * @param \Cegid\ArrayType\ArrayOfUserField $userFields
     * @param string $visaStatus
     */
    public function __construct($active = null, \Cegid\ArrayType\ArrayOfAddress $addresses = null, $cancelStatus = null, $currencyId = null, \Cegid\StructType\CustomerOrderHeaderCustomer $customer = null, $deliveryDate = null, $documentDate = null, \Cegid\StructType\CustomerOrderHeaderDocumentKey $documentKey = null, $effectiveDate = null, $expiryDate = null, $movementReasonId = null, \Cegid\StructType\CustomerOrderHeaderOmniChannel $omniChannel = null, \Cegid\StructType\CustomerOrderHeaderReferences $references = null, $salespersonId = null, $storeId = null, $taxIncluded = null, \Cegid\ArrayType\ArrayOfUserDefinedTable $userDefinedTables = null, \Cegid\ArrayType\ArrayOfUserField $userFields = null, $visaStatus = null)
    {
        $this
            ->setActive($active)
            ->setAddresses($addresses)
            ->setCancelStatus($cancelStatus)
            ->setCurrencyId($currencyId)
            ->setCustomer($customer)
            ->setDeliveryDate($deliveryDate)
            ->setDocumentDate($documentDate)
            ->setDocumentKey($documentKey)
            ->setEffectiveDate($effectiveDate)
            ->setExpiryDate($expiryDate)
            ->setMovementReasonId($movementReasonId)
            ->setOmniChannel($omniChannel)
            ->setReferences($references)
            ->setSalespersonId($salespersonId)
            ->setStoreId($storeId)
            ->setTaxIncluded($taxIncluded)
            ->setUserDefinedTables($userDefinedTables)
            ->setUserFields($userFields)
            ->setVisaStatus($visaStatus);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\ArrayType\ArrayOfAddress|null
     */
    public function getAddresses()
    {
        return isset($this->Addresses) ? $this->Addresses : null;
    }
    /**
     * Set Addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\ArrayType\ArrayOfAddress $addresses
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setAddresses(\Cegid\ArrayType\ArrayOfAddress $addresses = null)
    {
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->Addresses);
        } else {
            $this->Addresses = $addresses;
        }
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string|null
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \Cegid\EnumType\CustomerOrderCancelStatus::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderCancelStatus', is_array($cancelStatus) ? implode(', ', $cancelStatus) : var_export($cancelStatus, true), implode(', ', \Cegid\EnumType\CustomerOrderCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get CurrencyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyId()
    {
        return isset($this->CurrencyId) ? $this->CurrencyId : null;
    }
    /**
     * Set CurrencyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyId
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: string
        if (!is_null($currencyId) && !is_string($currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyId, true), gettype($currencyId)), __LINE__);
        }
        if (is_null($currencyId) || (is_array($currencyId) && empty($currencyId))) {
            unset($this->CurrencyId);
        } else {
            $this->CurrencyId = $currencyId;
        }
        return $this;
    }
    /**
     * Get Customer value
     * @return \Cegid\StructType\CustomerOrderHeaderCustomer|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Cegid\StructType\CustomerOrderHeaderCustomer $customer
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setCustomer(\Cegid\StructType\CustomerOrderHeaderCustomer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DocumentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }
    /**
     * Set DocumentDate value
     * @param string $documentDate
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        $this->DocumentDate = $documentDate;
        return $this;
    }
    /**
     * Get DocumentKey value
     * @return \Cegid\StructType\CustomerOrderHeaderDocumentKey|null
     */
    public function getDocumentKey()
    {
        return $this->DocumentKey;
    }
    /**
     * Set DocumentKey value
     * @param \Cegid\StructType\CustomerOrderHeaderDocumentKey $documentKey
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setDocumentKey(\Cegid\StructType\CustomerOrderHeaderDocumentKey $documentKey = null)
    {
        $this->DocumentKey = $documentKey;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get MovementReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovementReasonId()
    {
        return isset($this->MovementReasonId) ? $this->MovementReasonId : null;
    }
    /**
     * Set MovementReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $movementReasonId
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setMovementReasonId($movementReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($movementReasonId) && !is_string($movementReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($movementReasonId, true), gettype($movementReasonId)), __LINE__);
        }
        if (is_null($movementReasonId) || (is_array($movementReasonId) && empty($movementReasonId))) {
            unset($this->MovementReasonId);
        } else {
            $this->MovementReasonId = $movementReasonId;
        }
        return $this;
    }
    /**
     * Get OmniChannel value
     * @return \Cegid\StructType\CustomerOrderHeaderOmniChannel|null
     */
    public function getOmniChannel()
    {
        return $this->OmniChannel;
    }
    /**
     * Set OmniChannel value
     * @param \Cegid\StructType\CustomerOrderHeaderOmniChannel $omniChannel
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setOmniChannel(\Cegid\StructType\CustomerOrderHeaderOmniChannel $omniChannel = null)
    {
        $this->OmniChannel = $omniChannel;
        return $this;
    }
    /**
     * Get References value
     * @return \Cegid\StructType\CustomerOrderHeaderReferences|null
     */
    public function getReferences()
    {
        return $this->References;
    }
    /**
     * Set References value
     * @param \Cegid\StructType\CustomerOrderHeaderReferences $references
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setReferences(\Cegid\StructType\CustomerOrderHeaderReferences $references = null)
    {
        $this->References = $references;
        return $this;
    }
    /**
     * Get SalespersonId value
     * @return string|null
     */
    public function getSalespersonId()
    {
        return $this->SalespersonId;
    }
    /**
     * Set SalespersonId value
     * @param string $salespersonId
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setSalespersonId($salespersonId = null)
    {
        // validation for constraint: string
        if (!is_null($salespersonId) && !is_string($salespersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salespersonId, true), gettype($salespersonId)), __LINE__);
        }
        $this->SalespersonId = $salespersonId;
        return $this;
    }
    /**
     * Get StoreId value
     * @return string|null
     */
    public function getStoreId()
    {
        return $this->StoreId;
    }
    /**
     * Set StoreId value
     * @param string $storeId
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: string
        if (!is_null($storeId) && !is_string($storeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->StoreId = $storeId;
        return $this;
    }
    /**
     * Get TaxIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTaxIncluded()
    {
        return isset($this->TaxIncluded) ? $this->TaxIncluded : null;
    }
    /**
     * Set TaxIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $taxIncluded
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setTaxIncluded($taxIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxIncluded) && !is_bool($taxIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxIncluded, true), gettype($taxIncluded)), __LINE__);
        }
        if (is_null($taxIncluded) || (is_array($taxIncluded) && empty($taxIncluded))) {
            unset($this->TaxIncluded);
        } else {
            $this->TaxIncluded = $taxIncluded;
        }
        return $this;
    }
    /**
     * Get UserDefinedTables value
     * @return \Cegid\ArrayType\ArrayOfUserDefinedTable|null
     */
    public function getUserDefinedTables()
    {
        return $this->UserDefinedTables;
    }
    /**
     * Set UserDefinedTables value
     * @param \Cegid\ArrayType\ArrayOfUserDefinedTable $userDefinedTables
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setUserDefinedTables(\Cegid\ArrayType\ArrayOfUserDefinedTable $userDefinedTables = null)
    {
        $this->UserDefinedTables = $userDefinedTables;
        return $this;
    }
    /**
     * Get UserFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\ArrayType\ArrayOfUserField|null
     */
    public function getUserFields()
    {
        return isset($this->UserFields) ? $this->UserFields : null;
    }
    /**
     * Set UserFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\ArrayType\ArrayOfUserField $userFields
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setUserFields(\Cegid\ArrayType\ArrayOfUserField $userFields = null)
    {
        if (is_null($userFields) || (is_array($userFields) && empty($userFields))) {
            unset($this->UserFields);
        } else {
            $this->UserFields = $userFields;
        }
        return $this;
    }
    /**
     * Get VisaStatus value
     * @return string|null
     */
    public function getVisaStatus()
    {
        return $this->VisaStatus;
    }
    /**
     * Set VisaStatus value
     * @uses \Cegid\EnumType\CustomerOrderVisaStatus::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderVisaStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $visaStatus
     * @return \Cegid\StructType\CustomerOrderHeader
     */
    public function setVisaStatus($visaStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderVisaStatus::valueIsValid($visaStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderVisaStatus', is_array($visaStatus) ? implode(', ', $visaStatus) : var_export($visaStatus, true), implode(', ', \Cegid\EnumType\CustomerOrderVisaStatus::getValidValues())), __LINE__);
        }
        $this->VisaStatus = $visaStatus;
        return $this;
    }
}
