<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRequestLineProductDiscountCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateRequestLineProductDiscountCollection
 * @subpackage Structs
 */
class CreateRequestLineProductDiscountCollection extends AbstractStructBase
{
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestLineProductDiscount[]
     */
    public $Discount;
    /**
     * Constructor method for CreateRequestLineProductDiscountCollection
     * @uses CreateRequestLineProductDiscountCollection::setDiscount()
     * @param \Cegid\StructType\CreateRequestLineProductDiscount[] $discount
     */
    public function __construct(array $discount = array())
    {
        $this
            ->setDiscount($discount);
    }
    /**
     * Get Discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateRequestLineProductDiscount[]|null
     */
    public function getDiscount()
    {
        return isset($this->Discount) ? $this->Discount : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountForArrayConstraintsFromSetDiscount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createRequestLineProductDiscountCollectionDiscountItem) {
            // validation for constraint: itemType
            if (!$createRequestLineProductDiscountCollectionDiscountItem instanceof \Cegid\StructType\CreateRequestLineProductDiscount) {
                $invalidValues[] = is_object($createRequestLineProductDiscountCollectionDiscountItem) ? get_class($createRequestLineProductDiscountCollectionDiscountItem) : sprintf('%s(%s)', gettype($createRequestLineProductDiscountCollectionDiscountItem), var_export($createRequestLineProductDiscountCollectionDiscountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Discount property can only contain items of type \Cegid\StructType\CreateRequestLineProductDiscount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CreateRequestLineProductDiscount[] $discount
     * @return \Cegid\StructType\CreateRequestLineProductDiscountCollection
     */
    public function setDiscount(array $discount = array())
    {
        // validation for constraint: array
        if ('' !== ($discountArrayErrorMessage = self::validateDiscountForArrayConstraintsFromSetDiscount($discount))) {
            throw new \InvalidArgumentException($discountArrayErrorMessage, __LINE__);
        }
        if (is_null($discount) || (is_array($discount) && empty($discount))) {
            unset($this->Discount);
        } else {
            $this->Discount = $discount;
        }
        return $this;
    }
    /**
     * Add item to Discount value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CreateRequestLineProductDiscount $item
     * @return \Cegid\StructType\CreateRequestLineProductDiscountCollection
     */
    public function addToDiscount(\Cegid\StructType\CreateRequestLineProductDiscount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\CreateRequestLineProductDiscount) {
            throw new \InvalidArgumentException(sprintf('The Discount property can only contain items of type \Cegid\StructType\CreateRequestLineProductDiscount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Discount[] = $item;
        return $this;
    }
}
