<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRequestHeaderCustomerAddress StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateRequestHeaderCustomerAddress
 * @subpackage Structs
 */
class CreateRequestHeaderCustomerAddress extends AbstractStructBase
{
    /**
     * The City
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderCustomerAddressCompany
     */
    public $Company;
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CountryId;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The FiscalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FiscalId;
    /**
     * The Individual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderCustomerAddressIndividual
     */
    public $Individual;
    /**
     * The Lines
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CreateRequestHeaderCustomerAddressLineCollection
     */
    public $Lines;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegionId;
    /**
     * The Types
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType
     */
    public $Types;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for CreateRequestHeaderCustomerAddress
     * @uses CreateRequestHeaderCustomerAddress::setCity()
     * @uses CreateRequestHeaderCustomerAddress::setCompany()
     * @uses CreateRequestHeaderCustomerAddress::setCountryId()
     * @uses CreateRequestHeaderCustomerAddress::setEmail()
     * @uses CreateRequestHeaderCustomerAddress::setExternalReference()
     * @uses CreateRequestHeaderCustomerAddress::setFiscalId()
     * @uses CreateRequestHeaderCustomerAddress::setIndividual()
     * @uses CreateRequestHeaderCustomerAddress::setLines()
     * @uses CreateRequestHeaderCustomerAddress::setPhoneNumber()
     * @uses CreateRequestHeaderCustomerAddress::setRegionId()
     * @uses CreateRequestHeaderCustomerAddress::setTypes()
     * @uses CreateRequestHeaderCustomerAddress::setZipCode()
     * @param string $city
     * @param \Cegid\StructType\CreateRequestHeaderCustomerAddressCompany $company
     * @param string $countryId
     * @param string $email
     * @param string $externalReference
     * @param string $fiscalId
     * @param \Cegid\StructType\CreateRequestHeaderCustomerAddressIndividual $individual
     * @param \Cegid\StructType\CreateRequestHeaderCustomerAddressLineCollection $lines
     * @param string $phoneNumber
     * @param string $regionId
     * @param \Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType $types
     * @param string $zipCode
     */
    public function __construct($city = null, \Cegid\StructType\CreateRequestHeaderCustomerAddressCompany $company = null, $countryId = null, $email = null, $externalReference = null, $fiscalId = null, \Cegid\StructType\CreateRequestHeaderCustomerAddressIndividual $individual = null, \Cegid\StructType\CreateRequestHeaderCustomerAddressLineCollection $lines = null, $phoneNumber = null, $regionId = null, \Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType $types = null, $zipCode = null)
    {
        $this
            ->setCity($city)
            ->setCompany($company)
            ->setCountryId($countryId)
            ->setEmail($email)
            ->setExternalReference($externalReference)
            ->setFiscalId($fiscalId)
            ->setIndividual($individual)
            ->setLines($lines)
            ->setPhoneNumber($phoneNumber)
            ->setRegionId($regionId)
            ->setTypes($types)
            ->setZipCode($zipCode);
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddressCompany|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateRequestHeaderCustomerAddressCompany $company
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setCompany(\Cegid\StructType\CreateRequestHeaderCustomerAddressCompany $company = null)
    {
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get CountryId value
     * @return string|null
     */
    public function getCountryId()
    {
        return $this->CountryId;
    }
    /**
     * Set CountryId value
     * @param string $countryId
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: string
        if (!is_null($countryId) && !is_string($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->CountryId = $countryId;
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get FiscalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFiscalId()
    {
        return isset($this->FiscalId) ? $this->FiscalId : null;
    }
    /**
     * Set FiscalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fiscalId
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setFiscalId($fiscalId = null)
    {
        // validation for constraint: string
        if (!is_null($fiscalId) && !is_string($fiscalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fiscalId, true), gettype($fiscalId)), __LINE__);
        }
        if (is_null($fiscalId) || (is_array($fiscalId) && empty($fiscalId))) {
            unset($this->FiscalId);
        } else {
            $this->FiscalId = $fiscalId;
        }
        return $this;
    }
    /**
     * Get Individual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddressIndividual|null
     */
    public function getIndividual()
    {
        return isset($this->Individual) ? $this->Individual : null;
    }
    /**
     * Set Individual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateRequestHeaderCustomerAddressIndividual $individual
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setIndividual(\Cegid\StructType\CreateRequestHeaderCustomerAddressIndividual $individual = null)
    {
        if (is_null($individual) || (is_array($individual) && empty($individual))) {
            unset($this->Individual);
        } else {
            $this->Individual = $individual;
        }
        return $this;
    }
    /**
     * Get Lines value
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddressLineCollection|null
     */
    public function getLines()
    {
        return $this->Lines;
    }
    /**
     * Set Lines value
     * @param \Cegid\StructType\CreateRequestHeaderCustomerAddressLineCollection $lines
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setLines(\Cegid\StructType\CreateRequestHeaderCustomerAddressLineCollection $lines = null)
    {
        $this->Lines = $lines;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Get RegionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegionId()
    {
        return isset($this->RegionId) ? $this->RegionId : null;
    }
    /**
     * Set RegionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regionId
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setRegionId($regionId = null)
    {
        // validation for constraint: string
        if (!is_null($regionId) && !is_string($regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionId, true), gettype($regionId)), __LINE__);
        }
        if (is_null($regionId) || (is_array($regionId) && empty($regionId))) {
            unset($this->RegionId);
        } else {
            $this->RegionId = $regionId;
        }
        return $this;
    }
    /**
     * Get Types value
     * @return \Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType|null
     */
    public function getTypes()
    {
        return $this->Types;
    }
    /**
     * Set Types value
     * @param \Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType $types
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setTypes(\Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType $types = null)
    {
        $this->Types = $types;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \Cegid\StructType\CreateRequestHeaderCustomerAddress
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
}
