<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateFromRequestPaymentCreditCard StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateFromRequestPaymentCreditCard
 * @subpackage Structs
 */
class CreateFromRequestPaymentCreditCard extends AbstractStructBase
{
    /**
     * The AuthorizationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AuthorizationNumber;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TransactionNumber;
    /**
     * Constructor method for CreateFromRequestPaymentCreditCard
     * @uses CreateFromRequestPaymentCreditCard::setAuthorizationNumber()
     * @uses CreateFromRequestPaymentCreditCard::setTransactionNumber()
     * @param string $authorizationNumber
     * @param string $transactionNumber
     */
    public function __construct($authorizationNumber = null, $transactionNumber = null)
    {
        $this
            ->setAuthorizationNumber($authorizationNumber)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AuthorizationNumber value
     * @return string|null
     */
    public function getAuthorizationNumber()
    {
        return $this->AuthorizationNumber;
    }
    /**
     * Set AuthorizationNumber value
     * @param string $authorizationNumber
     * @return \Cegid\StructType\CreateFromRequestPaymentCreditCard
     */
    public function setAuthorizationNumber($authorizationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationNumber) && !is_string($authorizationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationNumber, true), gettype($authorizationNumber)), __LINE__);
        }
        $this->AuthorizationNumber = $authorizationNumber;
        return $this;
    }
    /**
     * Get TransactionNumber value
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return $this->TransactionNumber;
    }
    /**
     * Set TransactionNumber value
     * @param string $transactionNumber
     * @return \Cegid\StructType\CreateFromRequestPaymentCreditCard
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->TransactionNumber = $transactionNumber;
        return $this;
    }
}
