<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateFromRequestLine StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateFromRequestLine
 * @subpackage Structs
 */
class CreateFromRequestLine extends AbstractStructBase
{
    /**
     * The AdditionalDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdditionalDescription;
    /**
     * The CatalogReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CatalogReference;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The ItemIdentifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestLineItemIdentifier
     */
    public $ItemIdentifier;
    /**
     * The PackageReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackageReference;
    /**
     * The Quantity
     * @var float
     */
    public $Quantity;
    /**
     * The SalesPersonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesPersonId;
    /**
     * The SerialNumberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerialNumberId;
    /**
     * The WarehouseId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $WarehouseId;
    /**
     * Constructor method for CreateFromRequestLine
     * @uses CreateFromRequestLine::setAdditionalDescription()
     * @uses CreateFromRequestLine::setCatalogReference()
     * @uses CreateFromRequestLine::setExternalReference()
     * @uses CreateFromRequestLine::setItemIdentifier()
     * @uses CreateFromRequestLine::setPackageReference()
     * @uses CreateFromRequestLine::setQuantity()
     * @uses CreateFromRequestLine::setSalesPersonId()
     * @uses CreateFromRequestLine::setSerialNumberId()
     * @uses CreateFromRequestLine::setWarehouseId()
     * @param string $additionalDescription
     * @param string $catalogReference
     * @param string $externalReference
     * @param \Cegid\StructType\CreateFromRequestLineItemIdentifier $itemIdentifier
     * @param string $packageReference
     * @param float $quantity
     * @param string $salesPersonId
     * @param string $serialNumberId
     * @param string $warehouseId
     */
    public function __construct($additionalDescription = null, $catalogReference = null, $externalReference = null, \Cegid\StructType\CreateFromRequestLineItemIdentifier $itemIdentifier = null, $packageReference = null, $quantity = null, $salesPersonId = null, $serialNumberId = null, $warehouseId = null)
    {
        $this
            ->setAdditionalDescription($additionalDescription)
            ->setCatalogReference($catalogReference)
            ->setExternalReference($externalReference)
            ->setItemIdentifier($itemIdentifier)
            ->setPackageReference($packageReference)
            ->setQuantity($quantity)
            ->setSalesPersonId($salesPersonId)
            ->setSerialNumberId($serialNumberId)
            ->setWarehouseId($warehouseId);
    }
    /**
     * Get AdditionalDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalDescription()
    {
        return isset($this->AdditionalDescription) ? $this->AdditionalDescription : null;
    }
    /**
     * Set AdditionalDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalDescription
     * @return \Cegid\StructType\CreateFromRequestLine
     */
    public function setAdditionalDescription($additionalDescription = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDescription) && !is_string($additionalDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDescription, true), gettype($additionalDescription)), __LINE__);
        }
        if (is_null($additionalDescription) || (is_array($additionalDescription) && empty($additionalDescription))) {
            unset($this->AdditionalDescription);
        } else {
            $this->AdditionalDescription = $additionalDescription;
        }
        return $this;
    }
    /**
     * Get CatalogReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCatalogReference()
    {
        return isset($this->CatalogReference) ? $this->CatalogReference : null;
    }
    /**
     * Set CatalogReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $catalogReference
     * @return \Cegid\StructType\CreateFromRequestLine
     */
    public function setCatalogReference($catalogReference = null)
    {
        // validation for constraint: string
        if (!is_null($catalogReference) && !is_string($catalogReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalogReference, true), gettype($catalogReference)), __LINE__);
        }
        if (is_null($catalogReference) || (is_array($catalogReference) && empty($catalogReference))) {
            unset($this->CatalogReference);
        } else {
            $this->CatalogReference = $catalogReference;
        }
        return $this;
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \Cegid\StructType\CreateFromRequestLine
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get ItemIdentifier value
     * @return \Cegid\StructType\CreateFromRequestLineItemIdentifier|null
     */
    public function getItemIdentifier()
    {
        return $this->ItemIdentifier;
    }
    /**
     * Set ItemIdentifier value
     * @param \Cegid\StructType\CreateFromRequestLineItemIdentifier $itemIdentifier
     * @return \Cegid\StructType\CreateFromRequestLine
     */
    public function setItemIdentifier(\Cegid\StructType\CreateFromRequestLineItemIdentifier $itemIdentifier = null)
    {
        $this->ItemIdentifier = $itemIdentifier;
        return $this;
    }
    /**
     * Get PackageReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageReference()
    {
        return isset($this->PackageReference) ? $this->PackageReference : null;
    }
    /**
     * Set PackageReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageReference
     * @return \Cegid\StructType\CreateFromRequestLine
     */
    public function setPackageReference($packageReference = null)
    {
        // validation for constraint: string
        if (!is_null($packageReference) && !is_string($packageReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageReference, true), gettype($packageReference)), __LINE__);
        }
        if (is_null($packageReference) || (is_array($packageReference) && empty($packageReference))) {
            unset($this->PackageReference);
        } else {
            $this->PackageReference = $packageReference;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \Cegid\StructType\CreateFromRequestLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get SalesPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesPersonId()
    {
        return isset($this->SalesPersonId) ? $this->SalesPersonId : null;
    }
    /**
     * Set SalesPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesPersonId
     * @return \Cegid\StructType\CreateFromRequestLine
     */
    public function setSalesPersonId($salesPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($salesPersonId) && !is_string($salesPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesPersonId, true), gettype($salesPersonId)), __LINE__);
        }
        if (is_null($salesPersonId) || (is_array($salesPersonId) && empty($salesPersonId))) {
            unset($this->SalesPersonId);
        } else {
            $this->SalesPersonId = $salesPersonId;
        }
        return $this;
    }
    /**
     * Get SerialNumberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerialNumberId()
    {
        return isset($this->SerialNumberId) ? $this->SerialNumberId : null;
    }
    /**
     * Set SerialNumberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serialNumberId
     * @return \Cegid\StructType\CreateFromRequestLine
     */
    public function setSerialNumberId($serialNumberId = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumberId) && !is_string($serialNumberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumberId, true), gettype($serialNumberId)), __LINE__);
        }
        if (is_null($serialNumberId) || (is_array($serialNumberId) && empty($serialNumberId))) {
            unset($this->SerialNumberId);
        } else {
            $this->SerialNumberId = $serialNumberId;
        }
        return $this;
    }
    /**
     * Get WarehouseId value
     * @return string|null
     */
    public function getWarehouseId()
    {
        return $this->WarehouseId;
    }
    /**
     * Set WarehouseId value
     * @param string $warehouseId
     * @return \Cegid\StructType\CreateFromRequestLine
     */
    public function setWarehouseId($warehouseId = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseId) && !is_string($warehouseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseId, true), gettype($warehouseId)), __LINE__);
        }
        $this->WarehouseId = $warehouseId;
        return $this;
    }
}
