<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateFromRequestHeaderUserField StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateFromRequestHeaderUserField
 * @subpackage Structs
 */
class CreateFromRequestHeaderUserField extends AbstractStructBase
{
    /**
     * The Id
     * @var int
     */
    public $Id;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestHeaderUserFieldValue
     */
    public $Value;
    /**
     * The ValueType
     * @var string
     */
    public $ValueType;
    /**
     * Constructor method for CreateFromRequestHeaderUserField
     * @uses CreateFromRequestHeaderUserField::setId()
     * @uses CreateFromRequestHeaderUserField::setValue()
     * @uses CreateFromRequestHeaderUserField::setValueType()
     * @param int $id
     * @param \Cegid\StructType\CreateFromRequestHeaderUserFieldValue $value
     * @param string $valueType
     */
    public function __construct($id = null, \Cegid\StructType\CreateFromRequestHeaderUserFieldValue $value = null, $valueType = null)
    {
        $this
            ->setId($id)
            ->setValue($value)
            ->setValueType($valueType);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Cegid\StructType\CreateFromRequestHeaderUserField
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Value value
     * @return \Cegid\StructType\CreateFromRequestHeaderUserFieldValue|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \Cegid\StructType\CreateFromRequestHeaderUserFieldValue $value
     * @return \Cegid\StructType\CreateFromRequestHeaderUserField
     */
    public function setValue(\Cegid\StructType\CreateFromRequestHeaderUserFieldValue $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @uses \Cegid\EnumType\CustomerOrderUserFieldType::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderUserFieldType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueType
     * @return \Cegid\StructType\CreateFromRequestHeaderUserField
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderUserFieldType::valueIsValid($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderUserFieldType', is_array($valueType) ? implode(', ', $valueType) : var_export($valueType, true), implode(', ', \Cegid\EnumType\CustomerOrderUserFieldType::getValidValues())), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
}
