<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateFrom2ReplyDocumentCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateFrom2ReplyDocumentCollection
 * @subpackage Structs
 */
class CreateFrom2ReplyDocumentCollection extends AbstractStructBase
{
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateFrom2ReplyDocument[]
     */
    public $Document;
    /**
     * Constructor method for CreateFrom2ReplyDocumentCollection
     * @uses CreateFrom2ReplyDocumentCollection::setDocument()
     * @param \Cegid\StructType\CreateFrom2ReplyDocument[] $document
     */
    public function __construct(array $document = array())
    {
        $this
            ->setDocument($document);
    }
    /**
     * Get Document value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateFrom2ReplyDocument[]|null
     */
    public function getDocument()
    {
        return isset($this->Document) ? $this->Document : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createFrom2ReplyDocumentCollectionDocumentItem) {
            // validation for constraint: itemType
            if (!$createFrom2ReplyDocumentCollectionDocumentItem instanceof \Cegid\StructType\CreateFrom2ReplyDocument) {
                $invalidValues[] = is_object($createFrom2ReplyDocumentCollectionDocumentItem) ? get_class($createFrom2ReplyDocumentCollectionDocumentItem) : sprintf('%s(%s)', gettype($createFrom2ReplyDocumentCollectionDocumentItem), var_export($createFrom2ReplyDocumentCollectionDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \Cegid\StructType\CreateFrom2ReplyDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CreateFrom2ReplyDocument[] $document
     * @return \Cegid\StructType\CreateFrom2ReplyDocumentCollection
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        if (is_null($document) || (is_array($document) && empty($document))) {
            unset($this->Document);
        } else {
            $this->Document = $document;
        }
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CreateFrom2ReplyDocument $item
     * @return \Cegid\StructType\CreateFrom2ReplyDocumentCollection
     */
    public function addToDocument(\Cegid\StructType\CreateFrom2ReplyDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\CreateFrom2ReplyDocument) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \Cegid\StructType\CreateFrom2ReplyDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
}
