<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressCompany StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressCompany
 * @subpackage Structs
 */
class AddressCompany extends AbstractStructBase
{
    /**
     * The AdditionalName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AdditionalName;
    /**
     * The LegalFormId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LegalFormId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for AddressCompany
     * @uses AddressCompany::setAdditionalName()
     * @uses AddressCompany::setLegalFormId()
     * @uses AddressCompany::setName()
     * @param string $additionalName
     * @param string $legalFormId
     * @param string $name
     */
    public function __construct($additionalName = null, $legalFormId = null, $name = null)
    {
        $this
            ->setAdditionalName($additionalName)
            ->setLegalFormId($legalFormId)
            ->setName($name);
    }
    /**
     * Get AdditionalName value
     * @return string|null
     */
    public function getAdditionalName()
    {
        return $this->AdditionalName;
    }
    /**
     * Set AdditionalName value
     * @param string $additionalName
     * @return \Cegid\StructType\AddressCompany
     */
    public function setAdditionalName($additionalName = null)
    {
        // validation for constraint: string
        if (!is_null($additionalName) && !is_string($additionalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalName, true), gettype($additionalName)), __LINE__);
        }
        $this->AdditionalName = $additionalName;
        return $this;
    }
    /**
     * Get LegalFormId value
     * @return string|null
     */
    public function getLegalFormId()
    {
        return $this->LegalFormId;
    }
    /**
     * Set LegalFormId value
     * @param string $legalFormId
     * @return \Cegid\StructType\AddressCompany
     */
    public function setLegalFormId($legalFormId = null)
    {
        // validation for constraint: string
        if (!is_null($legalFormId) && !is_string($legalFormId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legalFormId, true), gettype($legalFormId)), __LINE__);
        }
        $this->LegalFormId = $legalFormId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Cegid\StructType\AddressCompany
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
