<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Address
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The City
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\AddressCompany
     */
    public $Company;
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CountryId;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Individual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\AddressIndividual
     */
    public $Individual;
    /**
     * The Lines
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\StructType\AddressLineCollection
     */
    public $Lines;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RegionId;
    /**
     * The Types
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType
     */
    public $Types;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for Address
     * @uses Address::setCity()
     * @uses Address::setCompany()
     * @uses Address::setCountryId()
     * @uses Address::setEmail()
     * @uses Address::setIndividual()
     * @uses Address::setLines()
     * @uses Address::setPhoneNumber()
     * @uses Address::setRegionId()
     * @uses Address::setTypes()
     * @uses Address::setZipCode()
     * @param string $city
     * @param \Cegid\StructType\AddressCompany $company
     * @param string $countryId
     * @param string $email
     * @param \Cegid\StructType\AddressIndividual $individual
     * @param \Cegid\StructType\AddressLineCollection $lines
     * @param string $phoneNumber
     * @param string $regionId
     * @param \Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType $types
     * @param string $zipCode
     */
    public function __construct($city = null, \Cegid\StructType\AddressCompany $company = null, $countryId = null, $email = null, \Cegid\StructType\AddressIndividual $individual = null, \Cegid\StructType\AddressLineCollection $lines = null, $phoneNumber = null, $regionId = null, \Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType $types = null, $zipCode = null)
    {
        $this
            ->setCity($city)
            ->setCompany($company)
            ->setCountryId($countryId)
            ->setEmail($email)
            ->setIndividual($individual)
            ->setLines($lines)
            ->setPhoneNumber($phoneNumber)
            ->setRegionId($regionId)
            ->setTypes($types)
            ->setZipCode($zipCode);
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Cegid\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\AddressCompany|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\AddressCompany $company
     * @return \Cegid\StructType\Address
     */
    public function setCompany(\Cegid\StructType\AddressCompany $company = null)
    {
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get CountryId value
     * @return string|null
     */
    public function getCountryId()
    {
        return $this->CountryId;
    }
    /**
     * Set CountryId value
     * @param string $countryId
     * @return \Cegid\StructType\Address
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: string
        if (!is_null($countryId) && !is_string($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->CountryId = $countryId;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \Cegid\StructType\Address
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Individual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\AddressIndividual|null
     */
    public function getIndividual()
    {
        return isset($this->Individual) ? $this->Individual : null;
    }
    /**
     * Set Individual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\AddressIndividual $individual
     * @return \Cegid\StructType\Address
     */
    public function setIndividual(\Cegid\StructType\AddressIndividual $individual = null)
    {
        if (is_null($individual) || (is_array($individual) && empty($individual))) {
            unset($this->Individual);
        } else {
            $this->Individual = $individual;
        }
        return $this;
    }
    /**
     * Get Lines value
     * @return \Cegid\StructType\AddressLineCollection|null
     */
    public function getLines()
    {
        return $this->Lines;
    }
    /**
     * Set Lines value
     * @param \Cegid\StructType\AddressLineCollection $lines
     * @return \Cegid\StructType\Address
     */
    public function setLines(\Cegid\StructType\AddressLineCollection $lines = null)
    {
        $this->Lines = $lines;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \Cegid\StructType\Address
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get RegionId value
     * @return string|null
     */
    public function getRegionId()
    {
        return $this->RegionId;
    }
    /**
     * Set RegionId value
     * @param string $regionId
     * @return \Cegid\StructType\Address
     */
    public function setRegionId($regionId = null)
    {
        // validation for constraint: string
        if (!is_null($regionId) && !is_string($regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionId, true), gettype($regionId)), __LINE__);
        }
        $this->RegionId = $regionId;
        return $this;
    }
    /**
     * Get Types value
     * @return \Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType|null
     */
    public function getTypes()
    {
        return $this->Types;
    }
    /**
     * Set Types value
     * @param \Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType $types
     * @return \Cegid\StructType\Address
     */
    public function setTypes(\Cegid\ArrayType\ArrayOfCustomerOrderDocumentAddressType $types = null)
    {
        $this->Types = $types;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \Cegid\StructType\Address
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
}
