<?php

namespace Cegid\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cegid\StructType\GetDetail $parameters
     * @return \Cegid\StructType\GetDetailResponse|bool
     */
    public function GetDetail(\Cegid\StructType\GetDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cegid\StructType\GetListDetail $parameters
     * @return \Cegid\StructType\GetListDetailResponse|bool
     */
    public function GetListDetail(\Cegid\StructType\GetListDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Cegid\StructType\GetDetailResponse|\Cegid\StructType\GetListDetailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
