<?php

namespace Cegid\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Create
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cegid\StructType\Create $parameters
     * @return \Cegid\StructType\CreateResponse|bool
     */
    public function Create(\Cegid\StructType\Create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateFrom
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cegid\StructType\CreateFrom $parameters
     * @return \Cegid\StructType\CreateFromResponse|bool
     */
    public function CreateFrom(\Cegid\StructType\CreateFrom $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateFrom($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateFrom2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cegid\StructType\CreateFrom2 $parameters
     * @return \Cegid\StructType\CreateFrom2Response|bool
     */
    public function CreateFrom2(\Cegid\StructType\CreateFrom2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateFrom2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Cegid\StructType\CreateFrom2Response|\Cegid\StructType\CreateFromResponse|\Cegid\StructType\CreateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
