<?php

namespace Cegid\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Close ServiceType
 * @subpackage Services
 */
class Close extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Close
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cegid\StructType\Close $parameters
     * @return \Cegid\StructType\CloseResponse|bool
     */
    public function Close(\Cegid\StructType\Close $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Close($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Cegid\StructType\CloseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
