<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetornoCliente StructType
 * @subpackage Structs
 */
class RetornoCliente extends RetornoInclusao
{
    /**
     * The lat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $lat;
    /**
     * The lon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $lon;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * Constructor method for RetornoCliente
     * @uses RetornoCliente::setLat()
     * @uses RetornoCliente::setLon()
     * @uses RetornoCliente::setId()
     * @param float $lat
     * @param float $lon
     * @param string $id
     */
    public function __construct($lat = null, $lon = null, $id = null)
    {
        $this
            ->setLat($lat)
            ->setLon($lon)
            ->setId($id);
    }
    /**
     * Get lat value
     * @return float
     */
    public function getLat()
    {
        return $this->lat;
    }
    /**
     * Set lat value
     * @param float $lat
     * @return \StructType\RetornoCliente
     */
    public function setLat($lat = null)
    {
        // validation for constraint: float
        if (!is_null($lat) && !(is_float($lat) || is_numeric($lat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lat, true), gettype($lat)), __LINE__);
        }
        $this->lat = $lat;
        return $this;
    }
    /**
     * Get lon value
     * @return float
     */
    public function getLon()
    {
        return $this->lon;
    }
    /**
     * Set lon value
     * @param float $lon
     * @return \StructType\RetornoCliente
     */
    public function setLon($lon = null)
    {
        // validation for constraint: float
        if (!is_null($lon) && !(is_float($lon) || is_numeric($lon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lon, true), gettype($lon)), __LINE__);
        }
        $this->lon = $lon;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\RetornoCliente
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
}
