<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sequenciar ServiceType
 * @subpackage Services
 */
class Sequenciar extends AbstractSoapClientBase
{
    /**
     * Sets the ValidationSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ValidationSoapHeader $validationSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderValidationSoapHeader(\StructType\ValidationSoapHeader $validationSoapHeader, $nameSpace = 'http://www.angellira.com.br/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ValidationSoapHeader', $validationSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SequenciarEntregas
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SequenciarEntregas $parameters
     * @return \StructType\SequenciarEntregasResponse|bool
     */
    public function SequenciarEntregas(\StructType\SequenciarEntregas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SequenciarEntregas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SequenciarEntregasResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
