<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRetornoItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfRetornoItem extends AbstractStructArrayBase
{
    /**
     * The RetornoItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetornoItem[]
     */
    public $RetornoItem;
    /**
     * Constructor method for ArrayOfRetornoItem
     * @uses ArrayOfRetornoItem::setRetornoItem()
     * @param \StructType\RetornoItem[] $retornoItem
     */
    public function __construct(array $retornoItem = array())
    {
        $this
            ->setRetornoItem($retornoItem);
    }
    /**
     * Get RetornoItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetornoItem[]|null
     */
    public function getRetornoItem()
    {
        return isset($this->RetornoItem) ? $this->RetornoItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRetornoItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRetornoItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRetornoItemForArrayConstraintsFromSetRetornoItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRetornoItemRetornoItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfRetornoItemRetornoItemItem instanceof \StructType\RetornoItem) {
                $invalidValues[] = is_object($arrayOfRetornoItemRetornoItemItem) ? get_class($arrayOfRetornoItemRetornoItemItem) : sprintf('%s(%s)', gettype($arrayOfRetornoItemRetornoItemItem), var_export($arrayOfRetornoItemRetornoItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RetornoItem property can only contain items of type \StructType\RetornoItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RetornoItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RetornoItem[] $retornoItem
     * @return \ArrayType\ArrayOfRetornoItem
     */
    public function setRetornoItem(array $retornoItem = array())
    {
        // validation for constraint: array
        if ('' !== ($retornoItemArrayErrorMessage = self::validateRetornoItemForArrayConstraintsFromSetRetornoItem($retornoItem))) {
            throw new \InvalidArgumentException($retornoItemArrayErrorMessage, __LINE__);
        }
        if (is_null($retornoItem) || (is_array($retornoItem) && empty($retornoItem))) {
            unset($this->RetornoItem);
        } else {
            $this->RetornoItem = $retornoItem;
        }
        return $this;
    }
    /**
     * Add item to RetornoItem value
     * @throws \InvalidArgumentException
     * @param \StructType\RetornoItem $item
     * @return \ArrayType\ArrayOfRetornoItem
     */
    public function addToRetornoItem(\StructType\RetornoItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RetornoItem) {
            throw new \InvalidArgumentException(sprintf('The RetornoItem property can only contain items of type \StructType\RetornoItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RetornoItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RetornoItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RetornoItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RetornoItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RetornoItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RetornoItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RetornoItem
     */
    public function getAttributeName()
    {
        return 'RetornoItem';
    }
}
