<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WayPoint StructType
 * @subpackage Structs
 */
class WayPoint extends AbstractStructBase
{
    /**
     * The lat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $lat;
    /**
     * The lng
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $lng;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The descricao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descricao;
    /**
     * Constructor method for WayPoint
     * @uses WayPoint::setLat()
     * @uses WayPoint::setLng()
     * @uses WayPoint::setId()
     * @uses WayPoint::setDescricao()
     * @param float $lat
     * @param float $lng
     * @param string $id
     * @param string $descricao
     */
    public function __construct($lat = null, $lng = null, $id = null, $descricao = null)
    {
        $this
            ->setLat($lat)
            ->setLng($lng)
            ->setId($id)
            ->setDescricao($descricao);
    }
    /**
     * Get lat value
     * @return float
     */
    public function getLat()
    {
        return $this->lat;
    }
    /**
     * Set lat value
     * @param float $lat
     * @return \StructType\WayPoint
     */
    public function setLat($lat = null)
    {
        // validation for constraint: float
        if (!is_null($lat) && !(is_float($lat) || is_numeric($lat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lat, true), gettype($lat)), __LINE__);
        }
        $this->lat = $lat;
        return $this;
    }
    /**
     * Get lng value
     * @return float
     */
    public function getLng()
    {
        return $this->lng;
    }
    /**
     * Set lng value
     * @param float $lng
     * @return \StructType\WayPoint
     */
    public function setLng($lng = null)
    {
        // validation for constraint: float
        if (!is_null($lng) && !(is_float($lng) || is_numeric($lng))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lng, true), gettype($lng)), __LINE__);
        }
        $this->lng = $lng;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\WayPoint
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\WayPoint
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
}
