<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationSoapHeader StructType
 * Meta information extracted from the WSDL
 * - type: tns:ValidationSoapHeader
 * @subpackage Structs
 */
class ValidationSoapHeader extends AbstractStructBase
{
    /**
     * The homologacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $homologacao;
    /**
     * The api_interna
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $api_interna;
    /**
     * The userCod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userCod;
    /**
     * The userPwd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userPwd;
    /**
     * Constructor method for ValidationSoapHeader
     * @uses ValidationSoapHeader::setHomologacao()
     * @uses ValidationSoapHeader::setApi_interna()
     * @uses ValidationSoapHeader::setUserCod()
     * @uses ValidationSoapHeader::setUserPwd()
     * @param bool $homologacao
     * @param bool $api_interna
     * @param string $userCod
     * @param string $userPwd
     */
    public function __construct($homologacao = null, $api_interna = null, $userCod = null, $userPwd = null)
    {
        $this
            ->setHomologacao($homologacao)
            ->setApi_interna($api_interna)
            ->setUserCod($userCod)
            ->setUserPwd($userPwd);
    }
    /**
     * Get homologacao value
     * @return bool
     */
    public function getHomologacao()
    {
        return $this->homologacao;
    }
    /**
     * Set homologacao value
     * @param bool $homologacao
     * @return \StructType\ValidationSoapHeader
     */
    public function setHomologacao($homologacao = null)
    {
        // validation for constraint: boolean
        if (!is_null($homologacao) && !is_bool($homologacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($homologacao, true), gettype($homologacao)), __LINE__);
        }
        $this->homologacao = $homologacao;
        return $this;
    }
    /**
     * Get api_interna value
     * @return bool
     */
    public function getApi_interna()
    {
        return $this->api_interna;
    }
    /**
     * Set api_interna value
     * @param bool $api_interna
     * @return \StructType\ValidationSoapHeader
     */
    public function setApi_interna($api_interna = null)
    {
        // validation for constraint: boolean
        if (!is_null($api_interna) && !is_bool($api_interna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($api_interna, true), gettype($api_interna)), __LINE__);
        }
        $this->api_interna = $api_interna;
        return $this;
    }
    /**
     * Get userCod value
     * @return string|null
     */
    public function getUserCod()
    {
        return $this->userCod;
    }
    /**
     * Set userCod value
     * @param string $userCod
     * @return \StructType\ValidationSoapHeader
     */
    public function setUserCod($userCod = null)
    {
        // validation for constraint: string
        if (!is_null($userCod) && !is_string($userCod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userCod, true), gettype($userCod)), __LINE__);
        }
        $this->userCod = $userCod;
        return $this;
    }
    /**
     * Get userPwd value
     * @return string|null
     */
    public function getUserPwd()
    {
        return $this->userPwd;
    }
    /**
     * Set userPwd value
     * @param string $userPwd
     * @return \StructType\ValidationSoapHeader
     */
    public function setUserPwd($userPwd = null)
    {
        // validation for constraint: string
        if (!is_null($userPwd) && !is_string($userPwd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userPwd, true), gettype($userPwd)), __LINE__);
        }
        $this->userPwd = $userPwd;
        return $this;
    }
}
