<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsuarioMobile StructType
 * @subpackage Structs
 */
class UsuarioMobile extends Retorno
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $codigo;
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The dispositivo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dispositivo;
    /**
     * Constructor method for UsuarioMobile
     * @uses UsuarioMobile::setCodigo()
     * @uses UsuarioMobile::setUsuario()
     * @uses UsuarioMobile::setDispositivo()
     * @param int $codigo
     * @param string $usuario
     * @param string $dispositivo
     */
    public function __construct($codigo = null, $usuario = null, $dispositivo = null)
    {
        $this
            ->setCodigo($codigo)
            ->setUsuario($usuario)
            ->setDispositivo($dispositivo);
    }
    /**
     * Get codigo value
     * @return int
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\UsuarioMobile
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\UsuarioMobile
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get dispositivo value
     * @return string|null
     */
    public function getDispositivo()
    {
        return $this->dispositivo;
    }
    /**
     * Set dispositivo value
     * @param string $dispositivo
     * @return \StructType\UsuarioMobile
     */
    public function setDispositivo($dispositivo = null)
    {
        // validation for constraint: string
        if (!is_null($dispositivo) && !is_string($dispositivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispositivo, true), gettype($dispositivo)), __LINE__);
        }
        $this->dispositivo = $dispositivo;
        return $this;
    }
}
