<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetornoRota StructType
 * @subpackage Structs
 */
class RetornoRota extends RetornoItem
{
    /**
     * The urlWeb
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $urlWeb;
    /**
     * The origem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $origem;
    /**
     * The destino
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $destino;
    /**
     * The caminhoLatitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $caminhoLatitude;
    /**
     * The caminhoLongitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $caminhoLongitude;
    /**
     * The pontoLatitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pontoLatitude;
    /**
     * The pontoLongitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pontoLongitude;
    /**
     * The pontos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pontos;
    /**
     * The caminho
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $caminho;
    /**
     * The entregas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $entregas;
    /**
     * The polilinha
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $polilinha;
    /**
     * The distancia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $distancia;
    /**
     * The tempo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $tempo;
    /**
     * Constructor method for RetornoRota
     * @uses RetornoRota::setUrlWeb()
     * @uses RetornoRota::setOrigem()
     * @uses RetornoRota::setDestino()
     * @uses RetornoRota::setCaminhoLatitude()
     * @uses RetornoRota::setCaminhoLongitude()
     * @uses RetornoRota::setPontoLatitude()
     * @uses RetornoRota::setPontoLongitude()
     * @uses RetornoRota::setPontos()
     * @uses RetornoRota::setCaminho()
     * @uses RetornoRota::setEntregas()
     * @uses RetornoRota::setPolilinha()
     * @uses RetornoRota::setDistancia()
     * @uses RetornoRota::setTempo()
     * @param string $urlWeb
     * @param string $origem
     * @param string $destino
     * @param string $caminhoLatitude
     * @param string $caminhoLongitude
     * @param string $pontoLatitude
     * @param string $pontoLongitude
     * @param string $pontos
     * @param string $caminho
     * @param \ArrayType\ArrayOfString $entregas
     * @param string $polilinha
     * @param float $distancia
     * @param float $tempo
     */
    public function __construct($urlWeb = null, $origem = null, $destino = null, $caminhoLatitude = null, $caminhoLongitude = null, $pontoLatitude = null, $pontoLongitude = null, $pontos = null, $caminho = null, \ArrayType\ArrayOfString $entregas = null, $polilinha = null, $distancia = null, $tempo = null)
    {
        $this
            ->setUrlWeb($urlWeb)
            ->setOrigem($origem)
            ->setDestino($destino)
            ->setCaminhoLatitude($caminhoLatitude)
            ->setCaminhoLongitude($caminhoLongitude)
            ->setPontoLatitude($pontoLatitude)
            ->setPontoLongitude($pontoLongitude)
            ->setPontos($pontos)
            ->setCaminho($caminho)
            ->setEntregas($entregas)
            ->setPolilinha($polilinha)
            ->setDistancia($distancia)
            ->setTempo($tempo);
    }
    /**
     * Get urlWeb value
     * @return string
     */
    public function getUrlWeb()
    {
        return $this->urlWeb;
    }
    /**
     * Set urlWeb value
     * @param string $urlWeb
     * @return \StructType\RetornoRota
     */
    public function setUrlWeb($urlWeb = null)
    {
        // validation for constraint: string
        if (!is_null($urlWeb) && !is_string($urlWeb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlWeb, true), gettype($urlWeb)), __LINE__);
        }
        $this->urlWeb = $urlWeb;
        return $this;
    }
    /**
     * Get origem value
     * @return string
     */
    public function getOrigem()
    {
        return $this->origem;
    }
    /**
     * Set origem value
     * @param string $origem
     * @return \StructType\RetornoRota
     */
    public function setOrigem($origem = null)
    {
        // validation for constraint: string
        if (!is_null($origem) && !is_string($origem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origem, true), gettype($origem)), __LINE__);
        }
        $this->origem = $origem;
        return $this;
    }
    /**
     * Get destino value
     * @return string
     */
    public function getDestino()
    {
        return $this->destino;
    }
    /**
     * Set destino value
     * @param string $destino
     * @return \StructType\RetornoRota
     */
    public function setDestino($destino = null)
    {
        // validation for constraint: string
        if (!is_null($destino) && !is_string($destino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destino, true), gettype($destino)), __LINE__);
        }
        $this->destino = $destino;
        return $this;
    }
    /**
     * Get caminhoLatitude value
     * @return string|null
     */
    public function getCaminhoLatitude()
    {
        return $this->caminhoLatitude;
    }
    /**
     * Set caminhoLatitude value
     * @param string $caminhoLatitude
     * @return \StructType\RetornoRota
     */
    public function setCaminhoLatitude($caminhoLatitude = null)
    {
        // validation for constraint: string
        if (!is_null($caminhoLatitude) && !is_string($caminhoLatitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caminhoLatitude, true), gettype($caminhoLatitude)), __LINE__);
        }
        $this->caminhoLatitude = $caminhoLatitude;
        return $this;
    }
    /**
     * Get caminhoLongitude value
     * @return string|null
     */
    public function getCaminhoLongitude()
    {
        return $this->caminhoLongitude;
    }
    /**
     * Set caminhoLongitude value
     * @param string $caminhoLongitude
     * @return \StructType\RetornoRota
     */
    public function setCaminhoLongitude($caminhoLongitude = null)
    {
        // validation for constraint: string
        if (!is_null($caminhoLongitude) && !is_string($caminhoLongitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caminhoLongitude, true), gettype($caminhoLongitude)), __LINE__);
        }
        $this->caminhoLongitude = $caminhoLongitude;
        return $this;
    }
    /**
     * Get pontoLatitude value
     * @return string|null
     */
    public function getPontoLatitude()
    {
        return $this->pontoLatitude;
    }
    /**
     * Set pontoLatitude value
     * @param string $pontoLatitude
     * @return \StructType\RetornoRota
     */
    public function setPontoLatitude($pontoLatitude = null)
    {
        // validation for constraint: string
        if (!is_null($pontoLatitude) && !is_string($pontoLatitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pontoLatitude, true), gettype($pontoLatitude)), __LINE__);
        }
        $this->pontoLatitude = $pontoLatitude;
        return $this;
    }
    /**
     * Get pontoLongitude value
     * @return string|null
     */
    public function getPontoLongitude()
    {
        return $this->pontoLongitude;
    }
    /**
     * Set pontoLongitude value
     * @param string $pontoLongitude
     * @return \StructType\RetornoRota
     */
    public function setPontoLongitude($pontoLongitude = null)
    {
        // validation for constraint: string
        if (!is_null($pontoLongitude) && !is_string($pontoLongitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pontoLongitude, true), gettype($pontoLongitude)), __LINE__);
        }
        $this->pontoLongitude = $pontoLongitude;
        return $this;
    }
    /**
     * Get pontos value
     * @return string|null
     */
    public function getPontos()
    {
        return $this->pontos;
    }
    /**
     * Set pontos value
     * @param string $pontos
     * @return \StructType\RetornoRota
     */
    public function setPontos($pontos = null)
    {
        // validation for constraint: string
        if (!is_null($pontos) && !is_string($pontos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pontos, true), gettype($pontos)), __LINE__);
        }
        $this->pontos = $pontos;
        return $this;
    }
    /**
     * Get caminho value
     * @return string|null
     */
    public function getCaminho()
    {
        return $this->caminho;
    }
    /**
     * Set caminho value
     * @param string $caminho
     * @return \StructType\RetornoRota
     */
    public function setCaminho($caminho = null)
    {
        // validation for constraint: string
        if (!is_null($caminho) && !is_string($caminho)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caminho, true), gettype($caminho)), __LINE__);
        }
        $this->caminho = $caminho;
        return $this;
    }
    /**
     * Get entregas value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getEntregas()
    {
        return $this->entregas;
    }
    /**
     * Set entregas value
     * @param \ArrayType\ArrayOfString $entregas
     * @return \StructType\RetornoRota
     */
    public function setEntregas(\ArrayType\ArrayOfString $entregas = null)
    {
        $this->entregas = $entregas;
        return $this;
    }
    /**
     * Get polilinha value
     * @return string|null
     */
    public function getPolilinha()
    {
        return $this->polilinha;
    }
    /**
     * Set polilinha value
     * @param string $polilinha
     * @return \StructType\RetornoRota
     */
    public function setPolilinha($polilinha = null)
    {
        // validation for constraint: string
        if (!is_null($polilinha) && !is_string($polilinha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($polilinha, true), gettype($polilinha)), __LINE__);
        }
        $this->polilinha = $polilinha;
        return $this;
    }
    /**
     * Get distancia value
     * @return float|null
     */
    public function getDistancia()
    {
        return $this->distancia;
    }
    /**
     * Set distancia value
     * @param float $distancia
     * @return \StructType\RetornoRota
     */
    public function setDistancia($distancia = null)
    {
        // validation for constraint: float
        if (!is_null($distancia) && !(is_float($distancia) || is_numeric($distancia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distancia, true), gettype($distancia)), __LINE__);
        }
        $this->distancia = $distancia;
        return $this;
    }
    /**
     * Get tempo value
     * @return float|null
     */
    public function getTempo()
    {
        return $this->tempo;
    }
    /**
     * Set tempo value
     * @param float $tempo
     * @return \StructType\RetornoRota
     */
    public function setTempo($tempo = null)
    {
        // validation for constraint: float
        if (!is_null($tempo) && !(is_float($tempo) || is_numeric($tempo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tempo, true), gettype($tempo)), __LINE__);
        }
        $this->tempo = $tempo;
        return $this;
    }
}
