<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CadProduto StructType
 * @subpackage Structs
 */
class CadProduto extends AbstractStructBase
{
    /**
     * The ProcEmbarque
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProcEmbarque;
    /**
     * The TipoLogistica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TipoLogistica;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Descricao;
    /**
     * The Referencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referencia;
    /**
     * Constructor method for CadProduto
     * @uses CadProduto::setProcEmbarque()
     * @uses CadProduto::setTipoLogistica()
     * @uses CadProduto::setDescricao()
     * @uses CadProduto::setReferencia()
     * @param int $procEmbarque
     * @param int $tipoLogistica
     * @param string $descricao
     * @param string $referencia
     */
    public function __construct($procEmbarque = null, $tipoLogistica = null, $descricao = null, $referencia = null)
    {
        $this
            ->setProcEmbarque($procEmbarque)
            ->setTipoLogistica($tipoLogistica)
            ->setDescricao($descricao)
            ->setReferencia($referencia);
    }
    /**
     * Get ProcEmbarque value
     * @return int
     */
    public function getProcEmbarque()
    {
        return $this->ProcEmbarque;
    }
    /**
     * Set ProcEmbarque value
     * @param int $procEmbarque
     * @return \StructType\CadProduto
     */
    public function setProcEmbarque($procEmbarque = null)
    {
        // validation for constraint: int
        if (!is_null($procEmbarque) && !(is_int($procEmbarque) || ctype_digit($procEmbarque))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($procEmbarque, true), gettype($procEmbarque)), __LINE__);
        }
        $this->ProcEmbarque = $procEmbarque;
        return $this;
    }
    /**
     * Get TipoLogistica value
     * @return int
     */
    public function getTipoLogistica()
    {
        return $this->TipoLogistica;
    }
    /**
     * Set TipoLogistica value
     * @param int $tipoLogistica
     * @return \StructType\CadProduto
     */
    public function setTipoLogistica($tipoLogistica = null)
    {
        // validation for constraint: int
        if (!is_null($tipoLogistica) && !(is_int($tipoLogistica) || ctype_digit($tipoLogistica))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoLogistica, true), gettype($tipoLogistica)), __LINE__);
        }
        $this->TipoLogistica = $tipoLogistica;
        return $this;
    }
    /**
     * Get Descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->Descricao;
    }
    /**
     * Set Descricao value
     * @param string $descricao
     * @return \StructType\CadProduto
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->Descricao = $descricao;
        return $this;
    }
    /**
     * Get Referencia value
     * @return string|null
     */
    public function getReferencia()
    {
        return $this->Referencia;
    }
    /**
     * Set Referencia value
     * @param string $referencia
     * @return \StructType\CadProduto
     */
    public function setReferencia($referencia = null)
    {
        // validation for constraint: string
        if (!is_null($referencia) && !is_string($referencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencia, true), gettype($referencia)), __LINE__);
        }
        $this->Referencia = $referencia;
        return $this;
    }
}
