<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the ValidationSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ValidationSoapHeader $validationSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderValidationSoapHeader(\StructType\ValidationSoapHeader $validationSoapHeader, $nameSpace = 'http://www.angellira.com.br/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ValidationSoapHeader', $validationSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetProcedimentoEmbarque
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProcedimentoEmbarque $parameters
     * @return \StructType\GetProcedimentoEmbarqueResponse|bool
     */
    public function GetProcedimentoEmbarque(\StructType\GetProcedimentoEmbarque $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProcedimentoEmbarque($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFaixaTemperatura
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFaixaTemperatura $parameters
     * @return \StructType\GetFaixaTemperaturaResponse|bool
     */
    public function GetFaixaTemperatura(\StructType\GetFaixaTemperatura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFaixaTemperatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRotas
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRotas $parameters
     * @return \StructType\GetRotasResponse|bool
     */
    public function GetRotas(\StructType\GetRotas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRotas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRota
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRota $parameters
     * @return \StructType\GetRotaResponse|bool
     */
    public function GetRota(\StructType\GetRota $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRota($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDispositivoAssociado
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDispositivoAssociado $parameters
     * @return \StructType\GetDispositivoAssociadoResponse|bool
     */
    public function GetDispositivoAssociado(\StructType\GetDispositivoAssociado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDispositivoAssociado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetDispositivoAssociadoResponse|\StructType\GetFaixaTemperaturaResponse|\StructType\GetProcedimentoEmbarqueResponse|\StructType\GetRotaResponse|\StructType\GetRotasResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
