<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Agendar ServiceType
 * @subpackage Services
 */
class Agendar extends AbstractSoapClientBase
{
    /**
     * Sets the ValidationSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ValidationSoapHeader $validationSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderValidationSoapHeader(\StructType\ValidationSoapHeader $validationSoapHeader, $nameSpace = 'http://www.angellira.com.br/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ValidationSoapHeader', $validationSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AgendarViagem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AgendarViagem $parameters
     * @return \StructType\AgendarViagemResponse|bool
     */
    public function AgendarViagem(\StructType\AgendarViagem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AgendarViagem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AgendarViagemResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
