<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCliente ArrayType
 * @subpackage Arrays
 */
class ArrayOfCliente extends AbstractStructArrayBase
{
    /**
     * The Cliente
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Cliente[]
     */
    public $Cliente;
    /**
     * Constructor method for ArrayOfCliente
     * @uses ArrayOfCliente::setCliente()
     * @param \StructType\Cliente[] $cliente
     */
    public function __construct(array $cliente = array())
    {
        $this
            ->setCliente($cliente);
    }
    /**
     * Get Cliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Cliente[]|null
     */
    public function getCliente()
    {
        return isset($this->Cliente) ? $this->Cliente : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCliente method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCliente method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClienteForArrayConstraintsFromSetCliente(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfClienteClienteItem) {
            // validation for constraint: itemType
            if (!$arrayOfClienteClienteItem instanceof \StructType\Cliente) {
                $invalidValues[] = is_object($arrayOfClienteClienteItem) ? get_class($arrayOfClienteClienteItem) : sprintf('%s(%s)', gettype($arrayOfClienteClienteItem), var_export($arrayOfClienteClienteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cliente property can only contain items of type \StructType\Cliente, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Cliente[] $cliente
     * @return \ArrayType\ArrayOfCliente
     */
    public function setCliente(array $cliente = array())
    {
        // validation for constraint: array
        if ('' !== ($clienteArrayErrorMessage = self::validateClienteForArrayConstraintsFromSetCliente($cliente))) {
            throw new \InvalidArgumentException($clienteArrayErrorMessage, __LINE__);
        }
        if (is_null($cliente) || (is_array($cliente) && empty($cliente))) {
            unset($this->Cliente);
        } else {
            $this->Cliente = $cliente;
        }
        return $this;
    }
    /**
     * Add item to Cliente value
     * @throws \InvalidArgumentException
     * @param \StructType\Cliente $item
     * @return \ArrayType\ArrayOfCliente
     */
    public function addToCliente(\StructType\Cliente $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cliente) {
            throw new \InvalidArgumentException(sprintf('The Cliente property can only contain items of type \StructType\Cliente, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cliente[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Cliente|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Cliente|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Cliente|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Cliente|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Cliente|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Cliente
     */
    public function getAttributeName()
    {
        return 'Cliente';
    }
}
