<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IniciarViagem StructType
 * @subpackage Structs
 */
class IniciarViagem extends AbstractStructBase
{
    /**
     * The data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $data;
    /**
     * The viagem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentificadorViagem
     */
    public $viagem;
    /**
     * The observacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $observacao;
    /**
     * Constructor method for IniciarViagem
     * @uses IniciarViagem::setData()
     * @uses IniciarViagem::setViagem()
     * @uses IniciarViagem::setObservacao()
     * @param string $data
     * @param \StructType\IdentificadorViagem $viagem
     * @param string $observacao
     */
    public function __construct($data = null, \StructType\IdentificadorViagem $viagem = null, $observacao = null)
    {
        $this
            ->setData($data)
            ->setViagem($viagem)
            ->setObservacao($observacao);
    }
    /**
     * Get data value
     * @return string
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\IniciarViagem
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Get viagem value
     * @return \StructType\IdentificadorViagem|null
     */
    public function getViagem()
    {
        return $this->viagem;
    }
    /**
     * Set viagem value
     * @param \StructType\IdentificadorViagem $viagem
     * @return \StructType\IniciarViagem
     */
    public function setViagem(\StructType\IdentificadorViagem $viagem = null)
    {
        $this->viagem = $viagem;
        return $this;
    }
    /**
     * Get observacao value
     * @return string|null
     */
    public function getObservacao()
    {
        return $this->observacao;
    }
    /**
     * Set observacao value
     * @param string $observacao
     * @return \StructType\IniciarViagem
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        $this->observacao = $observacao;
        return $this;
    }
}
