<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRotas StructType
 * @subpackage Structs
 */
class GetRotas extends AbstractStructBase
{
    /**
     * The UltimaRotaRecebida
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UltimaRotaRecebida;
    /**
     * The retornarPolilinha
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $retornarPolilinha;
    /**
     * The Pontos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PesquisaRota
     */
    public $Pontos;
    /**
     * The AglCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $AglCodes;
    /**
     * Constructor method for GetRotas
     * @uses GetRotas::setUltimaRotaRecebida()
     * @uses GetRotas::setRetornarPolilinha()
     * @uses GetRotas::setPontos()
     * @uses GetRotas::setAglCodes()
     * @param int $ultimaRotaRecebida
     * @param bool $retornarPolilinha
     * @param \StructType\PesquisaRota $pontos
     * @param \ArrayType\ArrayOfInt $aglCodes
     */
    public function __construct($ultimaRotaRecebida = null, $retornarPolilinha = null, \StructType\PesquisaRota $pontos = null, \ArrayType\ArrayOfInt $aglCodes = null)
    {
        $this
            ->setUltimaRotaRecebida($ultimaRotaRecebida)
            ->setRetornarPolilinha($retornarPolilinha)
            ->setPontos($pontos)
            ->setAglCodes($aglCodes);
    }
    /**
     * Get UltimaRotaRecebida value
     * @return int
     */
    public function getUltimaRotaRecebida()
    {
        return $this->UltimaRotaRecebida;
    }
    /**
     * Set UltimaRotaRecebida value
     * @param int $ultimaRotaRecebida
     * @return \StructType\GetRotas
     */
    public function setUltimaRotaRecebida($ultimaRotaRecebida = null)
    {
        // validation for constraint: int
        if (!is_null($ultimaRotaRecebida) && !(is_int($ultimaRotaRecebida) || ctype_digit($ultimaRotaRecebida))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ultimaRotaRecebida, true), gettype($ultimaRotaRecebida)), __LINE__);
        }
        $this->UltimaRotaRecebida = $ultimaRotaRecebida;
        return $this;
    }
    /**
     * Get retornarPolilinha value
     * @return bool
     */
    public function getRetornarPolilinha()
    {
        return $this->retornarPolilinha;
    }
    /**
     * Set retornarPolilinha value
     * @param bool $retornarPolilinha
     * @return \StructType\GetRotas
     */
    public function setRetornarPolilinha($retornarPolilinha = null)
    {
        // validation for constraint: boolean
        if (!is_null($retornarPolilinha) && !is_bool($retornarPolilinha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retornarPolilinha, true), gettype($retornarPolilinha)), __LINE__);
        }
        $this->retornarPolilinha = $retornarPolilinha;
        return $this;
    }
    /**
     * Get Pontos value
     * @return \StructType\PesquisaRota|null
     */
    public function getPontos()
    {
        return $this->Pontos;
    }
    /**
     * Set Pontos value
     * @param \StructType\PesquisaRota $pontos
     * @return \StructType\GetRotas
     */
    public function setPontos(\StructType\PesquisaRota $pontos = null)
    {
        $this->Pontos = $pontos;
        return $this;
    }
    /**
     * Get AglCodes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getAglCodes()
    {
        return $this->AglCodes;
    }
    /**
     * Set AglCodes value
     * @param \ArrayType\ArrayOfInt $aglCodes
     * @return \StructType\GetRotas
     */
    public function setAglCodes(\ArrayType\ArrayOfInt $aglCodes = null)
    {
        $this->AglCodes = $aglCodes;
        return $this;
    }
}
