<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.angellira.com.br/ws-soap/WSImport.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.angellira.com.br/ws-soap/WSImport.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Agendar ServiceType
 */
$agendar = new \ServiceType\Agendar($options);
$agendar->setSoapHeaderValidationSoapHeader(new \StructType\ValidationSoapHeader());
/**
 * Sample call for AgendarViagem operation/method
 */
if ($agendar->AgendarViagem(new \StructType\AgendarViagem()) !== false) {
    print_r($agendar->getResult());
} else {
    print_r($agendar->getLastError());
}
/**
 * Samples for Cadastrar ServiceType
 */
$cadastrar = new \ServiceType\Cadastrar($options);
$cadastrar->setSoapHeaderValidationSoapHeader(new \StructType\ValidationSoapHeader());
/**
 * Sample call for CadastrarCliente operation/method
 */
if ($cadastrar->CadastrarCliente(new \StructType\CadastrarCliente()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarTipoOcorrencia operation/method
 */
if ($cadastrar->CadastrarTipoOcorrencia(new \StructType\CadastrarTipoOcorrencia()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarProduto operation/method
 */
if ($cadastrar->CadastrarProduto(new \StructType\CadastrarProduto()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarUnidadePagadora operation/method
 */
if ($cadastrar->CadastrarUnidadePagadora(new \StructType\CadastrarUnidadePagadora()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Sample call for CadastrarAlocacaoDeCusto operation/method
 */
if ($cadastrar->CadastrarAlocacaoDeCusto(new \StructType\CadastrarAlocacaoDeCusto()) !== false) {
    print_r($cadastrar->getResult());
} else {
    print_r($cadastrar->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderValidationSoapHeader(new \StructType\ValidationSoapHeader());
/**
 * Sample call for GetProcedimentoEmbarque operation/method
 */
if ($get->GetProcedimentoEmbarque(new \StructType\GetProcedimentoEmbarque()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFaixaTemperatura operation/method
 */
if ($get->GetFaixaTemperatura(new \StructType\GetFaixaTemperatura()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRotas operation/method
 */
if ($get->GetRotas(new \StructType\GetRotas()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRota operation/method
 */
if ($get->GetRota(new \StructType\GetRota()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDispositivoAssociado operation/method
 */
if ($get->GetDispositivoAssociado(new \StructType\GetDispositivoAssociado()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Cancelar ServiceType
 */
$cancelar = new \ServiceType\Cancelar($options);
$cancelar->setSoapHeaderValidationSoapHeader(new \StructType\ValidationSoapHeader());
/**
 * Sample call for CancelarEntrega operation/method
 */
if ($cancelar->CancelarEntrega(new \StructType\CancelarEntrega()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Sample call for CancelarViagem operation/method
 */
if ($cancelar->CancelarViagem(new \StructType\CancelarViagem()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Samples for Atualizar ServiceType
 */
$atualizar = new \ServiceType\Atualizar($options);
$atualizar->setSoapHeaderValidationSoapHeader(new \StructType\ValidationSoapHeader());
/**
 * Sample call for AtualizarRotaViagem operation/method
 */
if ($atualizar->AtualizarRotaViagem(new \StructType\AtualizarRotaViagem()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Samples for Lista ServiceType
 */
$lista = new \ServiceType\Lista($options);
$lista->setSoapHeaderValidationSoapHeader(new \StructType\ValidationSoapHeader());
/**
 * Sample call for ListaTCAFranquia operation/method
 */
if ($lista->ListaTCAFranquia(new \StructType\ListaTCAFranquia()) !== false) {
    print_r($lista->getResult());
} else {
    print_r($lista->getLastError());
}
/**
 * Samples for Sequenciar ServiceType
 */
$sequenciar = new \ServiceType\Sequenciar($options);
$sequenciar->setSoapHeaderValidationSoapHeader(new \StructType\ValidationSoapHeader());
/**
 * Sample call for SequenciarEntregas operation/method
 */
if ($sequenciar->SequenciarEntregas(new \StructType\SequenciarEntregas()) !== false) {
    print_r($sequenciar->getResult());
} else {
    print_r($sequenciar->getLastError());
}
/**
 * Samples for Iniciar ServiceType
 */
$iniciar = new \ServiceType\Iniciar($options);
$iniciar->setSoapHeaderValidationSoapHeader(new \StructType\ValidationSoapHeader());
/**
 * Sample call for IniciarViagem operation/method
 */
if ($iniciar->IniciarViagem(new \StructType\IniciarViagem()) !== false) {
    print_r($iniciar->getResult());
} else {
    print_r($iniciar->getLastError());
}
/**
 * Samples for Finalizar ServiceType
 */
$finalizar = new \ServiceType\Finalizar($options);
$finalizar->setSoapHeaderValidationSoapHeader(new \StructType\ValidationSoapHeader());
/**
 * Sample call for FinalizarViagem operation/method
 */
if ($finalizar->FinalizarViagem(new \StructType\FinalizarViagem()) !== false) {
    print_r($finalizar->getResult());
} else {
    print_r($finalizar->getLastError());
}
/**
 * Samples for Enviar ServiceType
 */
$enviar = new \ServiceType\Enviar($options);
$enviar->setSoapHeaderValidationSoapHeader(new \StructType\ValidationSoapHeader());
/**
 * Sample call for EnviarIdentificacaoViagem operation/method
 */
if ($enviar->EnviarIdentificacaoViagem(new \StructType\EnviarIdentificacaoViagem()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
