<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Trecho StructType
 * @subpackage Structs
 */
class Trecho extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $index;
    /**
     * The pontos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pontos;
    /**
     * Constructor method for Trecho
     * @uses Trecho::setIndex()
     * @uses Trecho::setPontos()
     * @param int $index
     * @param string $pontos
     */
    public function __construct($index = null, $pontos = null)
    {
        $this
            ->setIndex($index)
            ->setPontos($pontos);
    }
    /**
     * Get index value
     * @return int
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param int $index
     * @return \StructType\Trecho
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !(is_int($index) || ctype_digit($index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get pontos value
     * @return string|null
     */
    public function getPontos()
    {
        return $this->pontos;
    }
    /**
     * Set pontos value
     * @param string $pontos
     * @return \StructType\Trecho
     */
    public function setPontos($pontos = null)
    {
        // validation for constraint: string
        if (!is_null($pontos) && !is_string($pontos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pontos, true), gettype($pontos)), __LINE__);
        }
        $this->pontos = $pontos;
        return $this;
    }
}
